/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.streams;

import com.google.common.collect.ImmutableSet;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.DbEntity;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.outputs.events.OutputChangedEvent;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Output;
import org.graylog2.rest.models.streams.outputs.requests.CreateOutputRequest;
import org.graylog2.streams.OutputImpl;
import org.graylog2.streams.OutputService;
import org.graylog2.streams.StreamService;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.DBUpdate;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;

public class OutputServiceImpl
implements OutputService {
    private final JacksonDBCollection<OutputImpl, String> coll;
    private final DBCollection dbCollection;
    private final StreamService streamService;
    private final ClusterEventBus clusterEventBus;

    @Inject
    public OutputServiceImpl(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapperProvider, StreamService streamService, ClusterEventBus clusterEventBus) {
        this.streamService = streamService;
        String collectionName = OutputImpl.class.getAnnotation(DbEntity.class).collection();
        this.dbCollection = mongoConnection.getDatabase().getCollection(collectionName);
        this.coll = JacksonDBCollection.wrap(this.dbCollection, OutputImpl.class, String.class, mapperProvider.get());
        this.clusterEventBus = clusterEventBus;
    }

    @Override
    public Output load(String streamOutputId) throws NotFoundException {
        Output output = this.coll.findOneById(streamOutputId);
        if (output == null) {
            throw new NotFoundException("Couldn't find output with id " + streamOutputId);
        }
        return output;
    }

    @Override
    public Set<Output> loadAll() {
        try (DBCursor<OutputImpl> outputs = this.coll.find();){
            ImmutableSet immutableSet = ImmutableSet.copyOf(outputs);
            return immutableSet;
        }
    }

    @Override
    public Set<Output> loadByIds(Collection<String> ids) {
        DBQuery.Query query = DBQuery.in((String)"_id", ids);
        try (DBCursor<OutputImpl> dbCursor = this.coll.find((Bson)query);){
            ImmutableSet immutableSet = ImmutableSet.copyOf(dbCursor);
            return immutableSet;
        }
    }

    @Override
    public Output create(Output request) throws ValidationException {
        OutputImpl outputImpl = this.implOrFail(request);
        WriteResult<OutputImpl, String> writeResult = this.coll.save(outputImpl);
        return writeResult.getSavedObject();
    }

    @Override
    public Output create(CreateOutputRequest request, String userId) throws ValidationException {
        return this.create(OutputImpl.create(new ObjectId().toHexString(), request.title(), request.type(), userId, request.configuration(), Tools.nowUTC().toDate(), request.contentPack()));
    }

    @Override
    public void destroy(Output model) throws NotFoundException {
        this.coll.removeById(model.getId());
        this.streamService.removeOutputFromAllStreams(model);
    }

    @Override
    public Output update(String id, Map<String, Object> deltas) {
        DBUpdate.Builder update = new DBUpdate.Builder();
        for (Map.Entry<String, Object> fields : deltas.entrySet()) {
            update = update.set(fields.getKey(), fields.getValue());
        }
        OutputImpl updatedOutput = this.coll.findAndModify((Bson)DBQuery.is((String)"_id", (Object)id), null, null, false, (OutputImpl)update, true, false);
        this.clusterEventBus.post(OutputChangedEvent.create(updatedOutput.getId()));
        return updatedOutput;
    }

    @Override
    public long count() {
        return this.coll.count();
    }

    @Override
    public Map<String, Long> countByType() {
        HashMap<String, Long> outputsCountByType = new HashMap<String, Long>();
        try (com.mongodb.DBCursor outputTypes = this.dbCollection.find(null, (DBObject)new BasicDBObject("type", (Object)1));){
            for (DBObject outputType : outputTypes) {
                String type = (String)outputType.get("type");
                if (type == null) continue;
                Long oldValue = (Long)outputsCountByType.get(type);
                Long newValue = oldValue == null ? 1L : oldValue + 1L;
                outputsCountByType.put(type, newValue);
            }
        }
        return outputsCountByType;
    }

    private OutputImpl implOrFail(Output output) {
        if (output instanceof OutputImpl) {
            OutputImpl outputImpl = (OutputImpl)output;
            return outputImpl;
        }
        throw new IllegalArgumentException("Supplied output must be of implementation type OutputImpl, not " + String.valueOf(output.getClass()));
    }
}

