/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.traffic;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.github.joschi.jadconfig.util.Size;
import jakarta.inject.Inject;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.system.traffic.TrafficCounterCalculator;
import org.graylog2.system.traffic.TrafficUpdater;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTrafficCounterCalculator
implements TrafficCounterCalculator {
    private static final Logger LOG = LoggerFactory.getLogger(OpenTrafficCounterCalculator.class);
    private final NodeId nodeId;
    private final TrafficUpdater trafficUpdater;
    private volatile long previousInputBytes = 0L;
    private volatile long previousOutputBytes = 0L;
    private volatile long previousDecodedBytes = 0L;
    private final Counter inputCounter;
    private final Counter outputCounter;
    private final Counter decodedCounter;

    @Inject
    public OpenTrafficCounterCalculator(NodeId nodeId, TrafficUpdater trafficUpdater, MetricRegistry metricRegistry) {
        this.nodeId = nodeId;
        this.trafficUpdater = trafficUpdater;
        this.inputCounter = metricRegistry.counter("org.graylog2.traffic.input");
        this.outputCounter = metricRegistry.counter("org.graylog2.traffic.output");
        this.decodedCounter = metricRegistry.counter("org.graylog2.traffic.decoded");
    }

    @Override
    public void calculate(DateTime previousMinute) {
        LOG.trace("Calculating input and output traffic for the previous minute");
        long currentInputBytes = this.inputCounter.getCount();
        long currentOutputBytes = this.outputCounter.getCount();
        long currentDecodedBytes = this.decodedCounter.getCount();
        long inputLastMinute = currentInputBytes - this.previousInputBytes;
        this.previousInputBytes = currentInputBytes;
        long outputBytesLastMinute = currentOutputBytes - this.previousOutputBytes;
        this.previousOutputBytes = currentOutputBytes;
        long decodedBytesLastMinute = currentDecodedBytes - this.previousDecodedBytes;
        this.previousDecodedBytes = currentDecodedBytes;
        if (LOG.isDebugEnabled()) {
            Size in = Size.bytes((long)inputLastMinute);
            Size out = Size.bytes((long)outputBytesLastMinute);
            Size decoded = Size.bytes((long)decodedBytesLastMinute);
            LOG.debug("Traffic in the last minute: in: {} bytes ({} MB), out: {} bytes ({} MB}), decoded: {} bytes ({} MB})", new Object[]{in, in.toMegabytes(), out, out.toMegabytes(), decoded, decoded.toMegabytes()});
        }
        this.trafficUpdater.updateTraffic(previousMinute, this.nodeId, inputLastMinute, outputBytesLastMinute, decodedBytesLastMinute);
    }
}

