/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.migrations;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.WriteModel;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.graylog.events.processor.EventDefinition;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.Migration;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.shared.utilities.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20230629140000_RenameFieldTypeOfEventDefinitionSeries
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20230629140000_RenameFieldTypeOfEventDefinitionSeries.class);
    private static final String SERIES_PATH_STRING = "config.series";
    private final ClusterConfigService clusterConfigService;
    private final MongoCollection<Document> collection;
    private final NotificationService notificationService;

    @Inject
    public V20230629140000_RenameFieldTypeOfEventDefinitionSeries(ClusterConfigService clusterConfigService, MongoConnection mongoConnection, NotificationService notificationService) {
        this.clusterConfigService = clusterConfigService;
        this.collection = mongoConnection.getMongoDatabase().getCollection("event_definitions");
        this.notificationService = notificationService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2023-06-29T14:00:00Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed.");
            return;
        }
        FindIterable result = this.collection.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"config.type", (Object)"aggregation-v1"), Filters.type((String)SERIES_PATH_STRING, (String)"array"), Filters.exists((String)"config.series.0")}));
        ArrayList<WriteModel<? extends Document>> bulkOperations = new ArrayList<WriteModel<? extends Document>>();
        for (Document doc : result) {
            this.processDoc(doc, bulkOperations);
        }
        if (bulkOperations.size() > 0) {
            this.collection.bulkWrite(bulkOperations);
        }
        this.clusterConfigService.write(new MigrationCompleted());
    }

    private void processDoc(Document doc, List<WriteModel<? extends Document>> bulkOperations) {
        Document config = (Document)doc.get((Object)"config", Document.class);
        List series = config.getList((Object)"series", Document.class, Collections.emptyList());
        boolean needsUpdate = false;
        boolean invalidSeries = false;
        ArrayList<Document> newSeries = new ArrayList<Document>(series.size());
        for (Document s : series) {
            if (invalidSeries) break;
            if (!s.containsKey((Object)"function")) {
                newSeries.add(s);
                continue;
            }
            needsUpdate = true;
            s.put("type", s.get((Object)"function"));
            s.remove((Object)"function");
            if (s.containsKey((Object)"field") && s.get((Object)"field") == null && (s.get((Object)"type").equals("avg") || s.get((Object)"type").equals("card") || s.get((Object)"type").equals("latest") || s.get((Object)"type").equals("max") || s.get((Object)"type").equals("min") || s.get((Object)"type").equals("percentile") || s.get((Object)"type").equals("stddev") || s.get((Object)"type").equals("sum") || s.get((Object)"type").equals("sumofsquares") || s.get((Object)"type").equals("variance"))) {
                invalidSeries = true;
                continue;
            }
            newSeries.add(s);
        }
        if (invalidSeries) {
            newSeries.clear();
            Document newConditions = new Document();
            newConditions.put("expression", null);
            config.put("conditions", (Object)newConditions);
            doc.put("state", (Object)EventDefinition.State.DISABLED);
            this.raiseNotification(StringUtils.f("Disabled invalid event definition %s", doc.get((Object)"title", String.class)), "Definition is missing the required field name - please review and update the definition.", "/alerts/definitions/" + doc.getObjectId((Object)"_id"));
        }
        if (needsUpdate) {
            config.put("series", newSeries);
            doc.put("config", (Object)config);
            bulkOperations.add((WriteModel<? extends Document>)new ReplaceOneModel(Filters.eq((String)"_id", (Object)doc.getObjectId((Object)"_id")), (Object)doc, new ReplaceOptions().upsert(false)));
        }
    }

    private void raiseNotification(String title, String details, String url) {
        Notification systemNotification = this.notificationService.buildNow().addType(Notification.Type.GENERIC_WITH_LINK).addSeverity(Notification.Severity.URGENT).addDetail("title", title).addDetail("GENERIC_DETAILS", details).addDetail("GENERIC_URL", url);
        this.notificationService.publishIfFirst(systemNotification);
    }

    public record MigrationCompleted() {
    }
}

