/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.periodicals;

import jakarta.inject.Inject;
import java.util.List;
import org.graylog.events.notifications.DBNotificationGracePeriodService;
import org.graylog.events.notifications.EventNotificationStatus;
import org.graylog.scheduler.clock.JobSchedulerClock;
import org.graylog2.plugin.periodical.Periodical;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventNotificationStatusCleanUp
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(EventNotificationStatusCleanUp.class);
    private final DBNotificationGracePeriodService dbNotificationGracePeriodService;
    private JobSchedulerClock clock;
    private static final long OUTOFDATE_IN_MS = 86400000L;

    @Inject
    public EventNotificationStatusCleanUp(DBNotificationGracePeriodService dbNotificationGracePeriodService, JobSchedulerClock clock) {
        this.dbNotificationGracePeriodService = dbNotificationGracePeriodService;
        this.clock = clock;
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return true;
    }

    @Override
    public boolean leaderOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 120;
    }

    @Override
    public int getPeriodSeconds() {
        return 86400;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void doRun() {
        int deleted = 0;
        List<EventNotificationStatus> eventNotificationStatuses = this.dbNotificationGracePeriodService.getAllStatuses();
        for (EventNotificationStatus status : eventNotificationStatuses) {
            DateTime triggeredAt;
            if (status.triggeredAt().isPresent() && (triggeredAt = status.triggeredAt().get()).isBefore((ReadableInstant)this.clock.nowUTC().minusMillis(86400000)) && status.gracePeriodMs() < 86400000L) {
                deleted += this.dbNotificationGracePeriodService.deleteStatus(status.id());
            }
            if (deleted <= 0) continue;
            LOG.debug("Deleted {} outdated notification statuses.", (Object)deleted);
        }
    }
}

