/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.processor.storage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.inject.assistedinject.Assisted;
import jakarta.inject.Inject;
import java.util.List;
import org.graylog.events.event.EventWithContext;
import org.graylog.events.indices.EventIndexer;
import org.graylog.events.processor.storage.AutoValue_PersistToStreamsStorageHandler_Config;
import org.graylog.events.processor.storage.EventStorageHandler;
import org.graylog.events.processor.storage.EventStorageHandlerCheckResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistToStreamsStorageHandler
implements EventStorageHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PersistToStreamsStorageHandler.class);
    private final Config config;
    private final EventIndexer indices;

    @Inject
    public PersistToStreamsStorageHandler(@Assisted EventStorageHandler.Config config, EventIndexer indices) {
        this.config = (Config)config;
        this.indices = indices;
    }

    @Override
    public void handleEvents(List<EventWithContext> eventsWithContext) {
        eventsWithContext.forEach(eventWithContext -> this.config.streams().forEach(stream -> eventWithContext.event().addStream((String)stream)));
        LOG.debug("Bulk-index {} events", (Object)eventsWithContext.size());
        this.indices.write(eventsWithContext);
    }

    @Override
    public EventStorageHandlerCheckResult checkPreconditions() {
        return EventStorageHandlerCheckResult.canExecute(true);
    }

    @JsonTypeName(value="persist-to-streams-v1")
    @JsonDeserialize(builder=Builder.class)
    @AutoValue
    public static abstract class Config
    implements EventStorageHandler.Config {
        public static final String TYPE_NAME = "persist-to-streams-v1";
        private static final String FIELD_STREAMS = "streams";

        @JsonProperty(value="streams")
        public abstract ImmutableList<String> streams();

        public static Builder builder() {
            return Builder.create();
        }

        public static Config createWithDefaultEventsStream() {
            return Builder.create().streams((List<String>)ImmutableList.of((Object)"000000000000000000000002")).build();
        }

        public static Config createWithSystemEventsStream() {
            return Builder.create().streams((List<String>)ImmutableList.of((Object)"000000000000000000000003")).build();
        }

        public abstract Builder toBuilder();

        @AutoValue.Builder
        public static abstract class Builder
        implements EventStorageHandler.Config.Builder<Builder> {
            @JsonCreator
            public static Builder create() {
                return new AutoValue_PersistToStreamsStorageHandler_Config.Builder().type(Config.TYPE_NAME).streams((List<String>)ImmutableList.of((Object)"000000000000000000000002"));
            }

            @JsonProperty(value="streams")
            public abstract Builder streams(List<String> var1);

            public abstract Config build();
        }
    }

    public static interface Factory
    extends EventStorageHandler.Factory<PersistToStreamsStorageHandler> {
        @Override
        public PersistToStreamsStorageHandler create(EventStorageHandler.Config var1);
    }
}

