/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.aws.codecs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.assistedinject.Assisted;
import jakarta.inject.Inject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.integrations.aws.cloudwatch.KinesisLogEntry;
import org.graylog.integrations.aws.codecs.AbstractKinesisCodec;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.MessageFactory;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.codecs.AbstractCodec;
import org.graylog2.plugin.inputs.codecs.Codec;

public class KinesisRawLogCodec
extends AbstractKinesisCodec {
    public static final String NAME = "CloudWatchRawLog";
    static final String SOURCE = "aws-kinesis-raw-logs";
    private final MessageFactory messageFactory;

    @Inject
    public KinesisRawLogCodec(@Assisted Configuration configuration, ObjectMapper objectMapper, MessageFactory messageFactory) {
        super(configuration, objectMapper);
        this.messageFactory = messageFactory;
    }

    @Override
    @Nullable
    public Message decodeLogData(@Nonnull KinesisLogEntry logEvent) {
        try {
            String source = this.configuration.getString("override_source", SOURCE);
            Message result = this.messageFactory.createMessage(logEvent.message(), source, logEvent.timestamp());
            result.addField("aws_kinesis_stream", logEvent.kinesisStream());
            result.addField("aws_log_group", logEvent.logGroup());
            result.addField("aws_log_stream", logEvent.logStream());
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not deserialize AWS FlowLog record.", e);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @ConfigClass
    public static class Config
    extends AbstractCodec.Config {
    }

    @FactoryClass
    public static interface Factory
    extends Codec.Factory<KinesisRawLogCodec> {
        @Override
        public KinesisRawLogCodec create(Configuration var1);

        @Override
        public Config getConfig();
    }
}

