/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.ipfix.codecs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import com.google.inject.assistedinject.Assisted;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.netty.buffer.Unpooled;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.integrations.ipfix.Flow;
import org.graylog.integrations.ipfix.InformationElementDefinitions;
import org.graylog.integrations.ipfix.IpfixException;
import org.graylog.integrations.ipfix.IpfixJournal;
import org.graylog.integrations.ipfix.IpfixParser;
import org.graylog.integrations.ipfix.TemplateRecord;
import org.graylog.integrations.ipfix.codecs.IpfixAggregator;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.MessageFactory;
import org.graylog2.plugin.ResolvableInetSocketAddress;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.ListField;
import org.graylog2.plugin.inputs.annotations.Codec;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.codecs.AbstractCodec;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.graylog2.plugin.inputs.codecs.CodecAggregator;
import org.graylog2.plugin.inputs.codecs.MultiMessageCodec;
import org.graylog2.plugin.journal.RawMessage;
import org.joda.time.DateTime;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Codec(name="ipfix", displayName="IPFIX Codec")
public class IpfixCodec
extends AbstractCodec
implements MultiMessageCodec {
    @VisibleForTesting
    static final String CK_IPFIX_DEFINITION_PATH = "ipfix_definition_path";
    private static final Logger LOG = LoggerFactory.getLogger(IpfixCodec.class);
    @VisibleForTesting
    static final String IPFIX_STANDARD_DEFINITION = "/ipfix-iana-elements.json";
    private final IpfixAggregator ipfixAggregator;
    private final MessageFactory messageFactory;
    private final IpfixParser parser;
    private InformationElementDefinitions infoElementDefs;

    @Inject
    protected IpfixCodec(@Assisted Configuration configuration, IpfixAggregator ipfixAggregator, MessageFactory messageFactory) throws IOException {
        super(configuration);
        this.ipfixAggregator = ipfixAggregator;
        this.messageFactory = messageFactory;
        URL standardIPFixDefTemplate = Resources.getResource(IpfixCodec.class, (String)IPFIX_STANDARD_DEFINITION);
        List<String> customDefFilePathList = configuration.getList(CK_IPFIX_DEFINITION_PATH);
        ArrayList<URL> filePaths = new ArrayList<URL>();
        if (customDefFilePathList == null || customDefFilePathList.isEmpty()) {
            this.infoElementDefs = new InformationElementDefinitions(standardIPFixDefTemplate);
        } else {
            this.checkValidFilePath(customDefFilePathList);
            filePaths.add(standardIPFixDefTemplate);
            for (String filePath : customDefFilePathList) {
                URL customDefURL = this.url(filePath.trim());
                filePaths.add(customDefURL);
            }
            URL[] urls = this.convertToArray(filePaths);
            this.infoElementDefs = new InformationElementDefinitions(urls);
        }
        this.parser = new IpfixParser(this.infoElementDefs);
    }

    URL url(String s) throws MalformedURLException {
        return Paths.get(s, new String[0]).toUri().toURL();
    }

    URL[] convertToArray(List<URL> urls) {
        URL[] urlArray = new URL[urls.size()];
        return urls.toArray(urlArray);
    }

    void checkValidFilePath(List<String> customDefFilePathList) throws IpfixException {
        for (String filePath : customDefFilePathList) {
            File file = new File(filePath.trim());
            this.validateFilePath(file);
        }
    }

    public void validateFilePath(File customDefFile) throws IpfixException {
        if (customDefFile.isDirectory()) {
            throw new IpfixException("The specified path is a folder. Please specify the full path to the file.");
        }
        if (!customDefFile.exists()) {
            throw new IpfixException("The specified file does not exist.");
        }
    }

    private static String toMessageString(Flow record) {
        LOG.debug("IPFIX message being assembled from flow record [{}].", record.fields());
        ImmutableMap<String, Object> fields = record.fields();
        long packetCount = (Long)fields.getOrDefault((Object)"packetDeltaCount", (Object)0L);
        long octetCount = (Long)fields.getOrDefault((Object)"octetDeltaCount", (Object)0L);
        if (octetCount == 0L) {
            octetCount = (Long)fields.getOrDefault((Object)"fwd_flow_delta_bytes", (Object)0L);
        }
        String srcAddr = (String)fields.get((Object)"sourceIPv4Address");
        String dstAddr = (String)fields.get((Object)"destinationIPv4Address");
        if (srcAddr == null) {
            srcAddr = (String)fields.get((Object)"sourceIPv6Address");
        }
        if (dstAddr == null) {
            dstAddr = (String)fields.get((Object)"destinationIPv6Address");
        }
        Number srcPort = (Number)fields.get((Object)"sourceTransportPort");
        Number dstPort = (Number)fields.get((Object)"destinationTransportPort");
        long protocol = Long.parseLong(String.valueOf(fields.getOrDefault((Object)"protocolIdentifier", (Object)0L)));
        return IpfixCodec.createMessageString(packetCount, octetCount, srcAddr, dstAddr, srcPort, dstPort, protocol);
    }

    private static String createMessageString(long packetCount, long octetCount, String srcAddr, String dstAddr, Number srcPort, Number dstPort, long protocol) {
        String message = String.format(Locale.ROOT, "Ipfix [" + srcAddr + "]:" + srcPort + " <> [" + dstAddr + "]:" + dstPort + " proto:" + protocol + " pkts:" + packetCount + " bytes:" + octetCount, new Object[0]);
        return message;
    }

    @Override
    @Nullable
    public CodecAggregator getAggregator() {
        return this.ipfixAggregator;
    }

    public InformationElementDefinitions getInfoElementDefs() {
        return this.infoElementDefs;
    }

    @Override
    @Nullable
    public Collection<Message> decodeMessages(@Nonnull RawMessage rawMessage) {
        LOG.debug("Attempting to decode raw messages now.");
        ResolvableInetSocketAddress remoteAddress = rawMessage.getRemoteAddress();
        InetSocketAddress sender = remoteAddress != null ? remoteAddress.getInetSocketAddress() : null;
        try {
            IpfixJournal.RawIpfix rawIpfix = IpfixJournal.RawIpfix.parseFrom(rawMessage.getPayload());
            Map<Integer, ByteString> templatesMap = rawIpfix.getTemplatesMap();
            Map templateRecordMap = Seq.seq(templatesMap).map(entry -> entry.map2(byteString -> this.parser.parseTemplateRecord(Unpooled.wrappedBuffer((byte[])byteString.toByteArray())))).toMap(Tuple2::v1, Tuple2::v2);
            return rawIpfix.getDataSetsList().stream().map(dataSet -> {
                int templateId = dataSet.getTemplateId();
                ZonedDateTime flowExportTimestamp = ZonedDateTime.ofInstant(Instant.ofEpochSecond(dataSet.getTimestampEpochSeconds()), ZoneOffset.UTC);
                TemplateRecord templateRecord = (TemplateRecord)templateRecordMap.get(templateId);
                if (templateRecord == null) {
                    throw new IpfixException("Missing required template in journal entry for data records: template id " + templateId);
                }
                Set<Flow> flows = this.parser.parseDataSet(templateRecord.informationElements(), templateRecordMap, Unpooled.wrappedBuffer((byte[])dataSet.getDataRecords().toByteArray()));
                return flows.stream().map(flow -> this.formatFlow(flowExportTimestamp, sender, (Flow)flow));
            }).flatMap(messageStream -> messageStream).collect(Collectors.toList());
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("Unable to parse ipfix journal message", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private Message formatFlow(ZonedDateTime flowExportTimestamp, InetSocketAddress sender, Flow flow) {
        ImmutableMap<String, Object> fields = flow.fields();
        DateTime timestamp = new DateTime((Object)Date.from(flowExportTimestamp.toInstant()));
        String source = sender == null ? null : sender.getAddress().getHostAddress();
        Message message = this.messageFactory.createMessage(IpfixCodec.toMessageString(flow), source, timestamp);
        message.addFields((Map<String, Object>)fields);
        return message;
    }

    @Override
    @Nullable
    public Message decode(@Nonnull RawMessage rawMessage) {
        throw new UnsupportedOperationException("MultiMessageCodec " + this.getClass() + " does not support decode()");
    }

    @ConfigClass
    public static class Config
    extends AbstractCodec.Config {
        @Override
        public void overrideDefaultValues(@Nonnull ConfigurationRequest cr) {
            if (cr.containsField("port")) {
                cr.getField("port").setDefaultValue(4739);
            }
        }

        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest configuration = super.getRequestedConfiguration();
            configuration.addField(new ListField(IpfixCodec.CK_IPFIX_DEFINITION_PATH, "IPFIX field definitions", Collections.emptyList(), Collections.emptyMap(), "JSON file containing IPFIX field definitions.", ConfigurationField.Optional.OPTIONAL, ListField.Attribute.ALLOW_CREATE));
            return configuration;
        }
    }

    @FactoryClass
    public static interface Factory
    extends Codec.Factory<IpfixCodec> {
        @Override
        public IpfixCodec create(Configuration var1);

        @Override
        public Config getConfig();
    }
}

