/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.conversion;

import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.functions.ips.IpAddress;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;
import org.joda.time.DateTime;

public class StringConversion
extends AbstractFunction<String> {
    public static final String NAME = "to_string";
    private final ThreadLocal<LinkedHashMap<Class<?>, Class<?>>> declaringClassCache = new ThreadLocal<LinkedHashMap<Class<?>, Class<?>>>(){

        @Override
        protected LinkedHashMap<Class<?>, Class<?>> initialValue() {
            return new LinkedHashMap<Class<?>, Class<?>>(){

                @Override
                protected boolean removeEldestEntry(Map.Entry<Class<?>, Class<?>> eldest) {
                    return this.size() > 1024;
                }
            };
        }
    };
    private final ParameterDescriptor<Object, Object> valueParam = ParameterDescriptor.object("value").ruleBuilderVariable().description("Value to convert").ruleBuilderVariable().build();
    private final ParameterDescriptor<String, String> defaultParam = ParameterDescriptor.string("default").optional().description("Used when 'value' is null, defaults to \"\"").build();

    @Override
    public String evaluate(FunctionArgs args, EvaluationContext context) {
        Object evaluated = this.valueParam.required(args, context);
        if (evaluated == null) {
            return this.defaultParam.optional(args, context).orElse("");
        }
        if (evaluated instanceof String || evaluated instanceof Number || evaluated instanceof Boolean || evaluated instanceof DateTime || evaluated instanceof IpAddress) {
            return evaluated.toString();
        }
        try {
            Class<?> klass = evaluated.getClass();
            LinkedHashMap<Class<?>, Class<?>> classCache = this.declaringClassCache.get();
            Class<?> declaringClass = classCache.get(klass);
            if (declaringClass == null) {
                declaringClass = klass.getMethod("toString", new Class[0]).getDeclaringClass();
                classCache.put(klass, declaringClass);
            }
            if (declaringClass != Object.class) {
                return evaluated.toString();
            }
            return this.defaultParam.optional(args, context).orElse("");
        }
        catch (NoSuchMethodException ignored) {
            return this.defaultParam.optional(args, context).orElse("");
        }
    }

    @Override
    public FunctionDescriptor<String> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(String.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.valueParam, this.defaultParam)).description("Converts a value to its string representation").ruleBuilderEnabled().ruleBuilderName("Convert to string").ruleBuilderTitle("Convert '${value}' to string").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.CONVERSION).build();
    }
}

