/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.lookup;

import jakarta.inject.Inject;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;
import org.graylog2.lookup.LookupTableService;

public class LookupAssignTtl
extends AbstractFunction<Object> {
    public static final String NAME = "lookup_assign_ttl";
    private final ParameterDescriptor<String, LookupTableService.Function> lookupTableParam = ParameterDescriptor.string("lookup_table", LookupTableService.Function.class).ruleBuilderVariable().description("The existing lookup table to use to add/update a ttl to the given key").transform(tableName -> lookupTableService.newBuilder().lookupTable((String)tableName).build()).build();
    private final ParameterDescriptor<Object, Object> keyParam = ParameterDescriptor.object("key").description("The key to update in the lookup table").build();
    private final ParameterDescriptor<Long, Long> ttlSecondsParam = ParameterDescriptor.integer("ttl").description("The time to live in seconds to assign to this entry").build();

    @Inject
    public LookupAssignTtl(LookupTableService lookupTableService) {
    }

    @Override
    public Object evaluate(FunctionArgs args, EvaluationContext context) {
        Object key = this.keyParam.required(args, context);
        if (key == null) {
            return null;
        }
        LookupTableService.Function table = this.lookupTableParam.required(args, context);
        if (table == null) {
            return null;
        }
        Long ttl = this.ttlSecondsParam.required(args, context);
        if (ttl == null) {
            return null;
        }
        return table.assignTtl(key, ttl).singleValue();
    }

    @Override
    public FunctionDescriptor<Object> descriptor() {
        return FunctionDescriptor.builder().name(NAME).description("Add a time to live to the key in the named lookup table. Returns the updated entry on success, null on failure.").params(this.lookupTableParam, this.keyParam, this.ttlSecondsParam).returnType(Object.class).ruleBuilderEnabled().ruleBuilderName("Add ttl to key in lookup table").ruleBuilderTitle("Add ${ttl} seconds ttl to key '${key}' in '${lookup_table}'").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.LOOKUP).build();
    }
}

