/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.strings;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import org.apache.commons.lang3.StringUtils;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;

public class Substring
extends AbstractFunction<String> {
    public static final String NAME = "substring";
    private final ParameterDescriptor<String, String> valueParam = ParameterDescriptor.string("value").description("The string to extract from").ruleBuilderVariable().build();
    private final ParameterDescriptor<Long, Long> startParam = ParameterDescriptor.integer("start").allowNegatives(true).description("The position to start from, negative means count back from the end of the String by this many characters").build();
    private final ParameterDescriptor<Long, Long> endParam = ParameterDescriptor.integer("indexEnd").optional().allowNegatives(true).description("The position to end at (exclusive), negative means count back from the end of the String by this many characters, defaults to length of the input string").build();

    @Override
    public String evaluate(FunctionArgs args, EvaluationContext context) {
        String value = this.valueParam.required(args, context);
        Long startValue = this.startParam.required(args, context);
        if (value == null || startValue == null) {
            return null;
        }
        int start = Ints.saturatedCast((long)startValue);
        int end = Ints.saturatedCast((long)this.endParam.optional(args, context).orElse(Long.valueOf(value.length())));
        return StringUtils.substring((String)value, (int)start, (int)end);
    }

    @Override
    public FunctionDescriptor<String> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(String.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.valueParam, this.startParam, this.endParam)).description("Extract a substring from a string").ruleBuilderEnabled().ruleBuilderName("Substring").ruleBuilderTitle("Get substring from '${start}' to '${indexEnd!\"end\"}' of '${value}'").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.STRING).build();
    }
}

