/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog.plugins.pipelineprocessor.ast.Pipeline;
import org.graylog.plugins.pipelineprocessor.db.PipelineDao;
import org.graylog.plugins.pipelineprocessor.parser.ParseException;
import org.graylog.plugins.pipelineprocessor.parser.PipelineRuleParser;
import org.graylog.plugins.pipelineprocessor.parser.errors.ParseError;
import org.graylog.plugins.pipelineprocessor.rest.AutoValue_PipelineSource;
import org.graylog.plugins.pipelineprocessor.rest.StageSource;
import org.joda.time.DateTime;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@JsonAutoDetect
@AutoValue
public abstract class PipelineSource {
    @JsonProperty(value="id")
    @Nullable
    @Id
    @ObjectId
    public abstract String id();

    @JsonProperty(value="title")
    @Nullable
    public abstract String title();

    @JsonProperty(value="description")
    @Nullable
    public abstract String description();

    @JsonProperty(value="source")
    public abstract String source();

    @JsonProperty(value="created_at")
    @Nullable
    public abstract DateTime createdAt();

    @JsonProperty(value="modified_at")
    @Nullable
    public abstract DateTime modifiedAt();

    @JsonProperty(value="stages")
    public abstract List<StageSource> stages();

    @JsonProperty(value="errors")
    @Nullable
    public abstract Set<ParseError> errors();

    public static Builder builder() {
        return new AutoValue_PipelineSource.Builder();
    }

    public abstract Builder toBuilder();

    @JsonCreator
    public static PipelineSource create(@JsonProperty(value="id") @Id @ObjectId @Nullable String id, @JsonProperty(value="title") String title, @JsonProperty(value="description") @Nullable String description, @JsonProperty(value="source") String source, @Nullable @JsonProperty(value="stages") List<StageSource> stages, @Nullable @JsonProperty(value="created_at") DateTime createdAt, @Nullable @JsonProperty(value="modified_at") DateTime modifiedAt) {
        return PipelineSource.builder().id(id).title(title).description(description).source(source).createdAt(createdAt).modifiedAt(modifiedAt).stages(stages == null ? Collections.emptyList() : stages).build();
    }

    public static PipelineSource fromDao(PipelineRuleParser parser, PipelineDao dao) {
        Set<ParseError> errors = null;
        Pipeline pipeline = null;
        try {
            pipeline = parser.parsePipeline(dao.id(), dao.source());
        }
        catch (ParseException e) {
            errors = e.getErrors();
        }
        List<StageSource> stageSources = pipeline == null ? Collections.emptyList() : pipeline.stages().stream().map(stage -> StageSource.builder().match(stage.match()).rules(stage.ruleReferences()).stage(stage.stage()).build()).collect(Collectors.toList());
        return PipelineSource.builder().id(dao.id()).title(dao.title()).description(dao.description()).source(dao.source()).createdAt(dao.createdAt()).modifiedAt(dao.modifiedAt()).stages(stageSources).errors(errors).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract PipelineSource build();

        public abstract Builder id(String var1);

        public abstract Builder title(String var1);

        public abstract Builder description(String var1);

        public abstract Builder source(String var1);

        public abstract Builder createdAt(DateTime var1);

        public abstract Builder modifiedAt(DateTime var1);

        public abstract Builder stages(List<StageSource> var1);

        public abstract Builder errors(Set<ParseError> var1);
    }
}

