/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rulebuilder.rest;

import com.swrve.ratelimitedlogger.RateLimitedLog;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.plugins.pipelineprocessor.ast.Rule;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.processors.PipelineInterpreter;
import org.graylog.plugins.pipelineprocessor.rest.PipelineRuleService;
import org.graylog.plugins.pipelineprocessor.rest.RuleResource;
import org.graylog.plugins.pipelineprocessor.rest.RuleSource;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilder;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderRegistry;
import org.graylog.plugins.pipelineprocessor.rulebuilder.db.RuleFragment;
import org.graylog.plugins.pipelineprocessor.rulebuilder.parser.RuleBuilderService;
import org.graylog.plugins.pipelineprocessor.rulebuilder.parser.validation.ValidatorService;
import org.graylog.plugins.pipelineprocessor.rulebuilder.rest.RuleBuilderDto;
import org.graylog.plugins.pipelineprocessor.rulebuilder.rest.RuleBuilderSimulatorResponse;
import org.graylog.plugins.pipelineprocessor.rulebuilder.rest.SimulateRuleBuilderRequest;
import org.graylog.plugins.pipelineprocessor.simulator.RuleSimulator;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="Pipelines/Rulebuilder", description="Rules for the pipeline message processor generated using the rulebuilder", tags={"cloud"})
@Path(value="/system/pipelines/rulebuilder")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@RequiresAuthentication
public class RuleBuilderResource
extends RestResource
implements PluginRestResource {
    private static final RateLimitedLog log = PipelineInterpreter.getRateLimitedLog(RuleBuilderResource.class);
    private final RuleBuilderRegistry ruleBuilderRegistry;
    private final RuleResource ruleResource;
    private final RuleBuilderService ruleBuilderParser;
    private final ValidatorService validatorService;
    private final RuleSimulator ruleSimulator;
    private final PipelineRuleService pipelineRuleService;

    @Inject
    public RuleBuilderResource(RuleBuilderRegistry ruleBuilderRegistry, RuleResource ruleResource, RuleBuilderService ruleBuilderParser, ValidatorService validatorService, RuleSimulator ruleSimulator, PipelineRuleService pipelineRuleService) {
        this.ruleBuilderRegistry = ruleBuilderRegistry;
        this.ruleResource = ruleResource;
        this.ruleBuilderParser = ruleBuilderParser;
        this.validatorService = validatorService;
        this.ruleSimulator = ruleSimulator;
        this.pipelineRuleService = pipelineRuleService;
    }

    @ApiOperation(value="Create a processing rule from rule builder", notes="")
    @POST
    @RequiresPermissions(value={"pipeline_rule:create"})
    @AuditEvent(type="pipeline_processor:rule:create")
    public RuleBuilderDto createFromBuilder(@ApiParam(name="rule", required=true) @NotNull RuleBuilderDto ruleBuilderDto) {
        try {
            this.validatorService.validateAndFailFast(ruleBuilderDto);
        }
        catch (IllegalArgumentException exception) {
            throw new BadRequestException(exception.getMessage());
        }
        RuleSource ruleSource = this.toRuleSource(ruleBuilderDto, false);
        RuleSource stored = this.ruleResource.createFromParser(ruleSource);
        return ruleBuilderDto.toBuilder().id(stored.id()).build();
    }

    @ApiOperation(value="Update a processing rule from rule builder", notes="")
    @Path(value="/{id}")
    @PUT
    @RequiresPermissions(value={"pipeline_rule:create"})
    @AuditEvent(type="pipeline_processor:rule:create")
    public RuleBuilderDto updateFromBuilder(@ApiParam(name="id") @PathParam(value="id") String id, @ApiParam(name="rule", required=true) @NotNull RuleBuilderDto ruleBuilderDto) throws NotFoundException {
        RuleSource ruleSource = this.toRuleSource(ruleBuilderDto, false);
        RuleSource stored = this.ruleResource.update(id, ruleSource);
        return ruleBuilderDto.toBuilder().id(stored.id()).build();
    }

    @ApiOperation(value="Get action descriptors for rule builder")
    @Path(value="/actions")
    @GET
    public Collection<Object> actions() {
        return this.ruleBuilderRegistry.actions().values().stream().map(RuleFragment::descriptor).sorted(Comparator.comparing(FunctionDescriptor::ruleBuilderName)).collect(Collectors.toList());
    }

    @ApiOperation(value="Get condition descriptors for ruleBuilder")
    @Path(value="/conditions")
    @GET
    public Collection<Object> conditions() {
        return this.ruleBuilderRegistry.conditions().values().stream().map(RuleFragment::descriptor).sorted(Comparator.comparing(FunctionDescriptor::ruleBuilderName)).collect(Collectors.toList());
    }

    @ApiOperation(value="Validate rule builder")
    @Path(value="/validate")
    @POST
    @NoAuditEvent(value="Used to validate rule builder")
    public RuleBuilderDto validate(@ApiParam(name="rule", required=true) @NotNull RuleBuilderDto ruleBuilderDto) {
        RuleBuilderDto validated = this.validatorService.validate(ruleBuilderDto);
        return validated.toBuilder().ruleBuilder(this.ruleBuilderParser.generateTitles(validated.ruleBuilder())).build();
    }

    @ApiOperation(value="Simulate a single processing rule created by the rule builder")
    @Path(value="/simulate")
    @POST
    @NoAuditEvent(value="Only used to simulate a rule builder")
    public RuleBuilderSimulatorResponse simulate(@ApiParam(name="rule", required=true) @NotNull SimulateRuleBuilderRequest simulateRuleBuilderRequest) {
        Message message = this.ruleSimulator.createMessage(simulateRuleBuilderRequest.message());
        RuleSource ruleSourceConditions = RuleSource.builder().source(this.ruleBuilderParser.generateSimulatorRuleSourceEvaluatingConditions(simulateRuleBuilderRequest.ruleBuilderDto().ruleBuilder())).build();
        Rule rule1 = this.pipelineRuleService.parseRuleOrThrow(ruleSourceConditions.id(), ruleSourceConditions.source(), true);
        Message conditionResult = this.ruleSimulator.simulate(rule1, message);
        RuleSource ruleSource = this.toRuleSource(simulateRuleBuilderRequest.ruleBuilderDto(), true);
        Rule rule2 = this.pipelineRuleService.parseRuleOrThrow(ruleSource.id(), ruleSource.source(), true);
        Message result = this.ruleSimulator.simulate(rule2, conditionResult);
        return new RuleBuilderSimulatorResponse(result);
    }

    private RuleSource toRuleSource(RuleBuilderDto ruleBuilderDto, boolean generateSimulatorFields) {
        RuleBuilder ruleBuilder = generateSimulatorFields ? ruleBuilderDto.ruleBuilder() : ruleBuilderDto.ruleBuilder().normalize();
        return RuleSource.builder().title(ruleBuilderDto.title()).description(ruleBuilderDto.description()).ruleBuilder(this.ruleBuilderParser.generateTitles(ruleBuilder)).source(this.ruleBuilderParser.generateRuleSource(ruleBuilderDto.title(), ruleBuilder, generateSimulatorFields)).simulatorMessage(ruleBuilderDto.simulatorMessage()).build();
    }
}

