/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.favorites;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotEmpty;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.Optional;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.views.favorites.Favorite;
import org.graylog.plugins.views.favorites.FavoritesService;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.rest.models.PaginatedResponse;

@Api(value="Favorites", tags={"cloud"})
@Path(value="/favorites")
@Produces(value={"application/json"})
@RequiresAuthentication
public class FavoritesResource {
    private final FavoritesService favoritesService;

    @Inject
    public FavoritesResource(FavoritesService favoritesService) {
        this.favoritesService = favoritesService;
    }

    @GET
    @ApiOperation(value="Get the Favorites for the Start Page for the user")
    public PaginatedResponse<Favorite> getFavoriteItems(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="5") int perPage, @ApiParam(name="type") @QueryParam(value="type") Optional<String> type, @Context SearchUser searchUser) {
        return this.favoritesService.findFavoritesFor(searchUser, type, page, perPage);
    }

    @PUT
    @Path(value="/{grn}")
    @ApiOperation(value="Add an item for inclusion on the Start Page for the user")
    @AuditEvent(type="views:dynamic_startup_page:addFavoriteItem")
    public void addItemToFavorites(@ApiParam(name="grn", required=true) @PathParam(value="grn") @NotEmpty String grn, @Context SearchUser searchUser) {
        this.favoritesService.addFavoriteItemFor(grn, searchUser);
    }

    @DELETE
    @Path(value="/{grn}")
    @ApiOperation(value="Remove an item from inclusion on the Start Page for the user")
    @AuditEvent(type="views:dynamic_startup_page:removeFavoriteItem")
    public void removeItemFromFavorites(@ApiParam(name="grn", required=true) @PathParam(value="grn") @NotEmpty String grn, @Context SearchUser searchUser) {
        this.favoritesService.removeFavoriteItemFor(grn, searchUser);
    }
}

