/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.export;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.result.InsertOneResult;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.bson.types.ObjectId;
import org.graylog.plugins.views.search.export.ExportJob;
import org.graylog2.database.MongoCollections;
import org.graylog2.database.utils.MongoUtils;

public class ExportJobService {
    protected final MongoCollection<ExportJob> db;
    private final MongoUtils<ExportJob> mongoUtils;

    @Inject
    public ExportJobService(MongoCollections mongoCollections) {
        this.db = mongoCollections.collection("export_jobs", ExportJob.class);
        this.db.createIndex(Indexes.ascending((String[])new String[]{"created_at"}), new IndexOptions().expireAfter(Long.valueOf(1L), TimeUnit.HOURS));
        this.mongoUtils = mongoCollections.utils(this.db);
    }

    public Optional<ExportJob> get(String id) {
        if (!ObjectId.isValid((String)id)) {
            return Optional.empty();
        }
        return this.mongoUtils.getById(id);
    }

    public String save(ExportJob exportJob) {
        InsertOneResult save = this.db.insertOne((Object)exportJob);
        return MongoUtils.insertedIdAsString(save);
    }
}

