/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.filter.AutoValue_StreamCategoryFilter;
import org.graylog.plugins.views.search.filter.StreamFilter;
import org.graylog.plugins.views.search.permissions.StreamPermissions;

@JsonTypeName(value="stream_category")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class StreamCategoryFilter
implements Filter {
    public static final String NAME = "stream_category";

    @Override
    @JsonProperty
    public abstract String type();

    @Override
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public abstract Set<Filter> filters();

    @JsonProperty(value="category")
    public abstract String category();

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    public static StreamCategoryFilter ofCategory(String category) {
        return StreamCategoryFilter.builder().category(category).build();
    }

    public Filter toStreamFilter(Function<Collection<String>, Stream<String>> categoryMappingFunction, StreamPermissions streamPermissions) {
        String[] mappedStreamIds = (String[])categoryMappingFunction.apply(List.of(this.category())).filter(streamPermissions::canReadStream).toArray(String[]::new);
        if (mappedStreamIds.length == 0) {
            return null;
        }
        Filter streamFilter = StreamFilter.anyIdOf(mappedStreamIds).toGenericBuilder().build();
        if (this.filters() != null) {
            streamFilter = streamFilter.toGenericBuilder().filters(this.filters()).build();
        }
        return streamFilter;
    }

    @Override
    public Filter.Builder toGenericBuilder() {
        return this.toBuilder();
    }

    @AutoValue.Builder
    public static abstract class Builder
    implements Filter.Builder {
        @JsonProperty
        public abstract Builder type(String var1);

        @Override
        @JsonProperty
        public abstract Builder filters(@Nullable Set<Filter> var1);

        @JsonProperty(value="category")
        public abstract Builder category(String var1);

        @Override
        public abstract StreamCategoryFilter build();

        @JsonCreator
        public static Builder create() {
            return new AutoValue_StreamCategoryFilter.Builder().type(StreamCategoryFilter.NAME);
        }
    }
}

