/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.google.common.collect.ImmutableSet;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.time.Instant;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.views.search.ExplainResults;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.elasticsearch.IndexLookup;
import org.graylog.plugins.views.search.explain.DataRoutedStream;
import org.graylog.plugins.views.search.explain.StreamQueryExplainer;
import org.graylog.plugins.views.search.explain.StreamQueryInfo;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.ValidationMessageDTO;
import org.graylog.plugins.views.search.rest.ValidationRequestDTO;
import org.graylog.plugins.views.search.rest.ValidationResponseDTO;
import org.graylog.plugins.views.search.rest.ValidationStatusDTO;
import org.graylog.plugins.views.search.rest.ValidationTypeDTO;
import org.graylog.plugins.views.search.validation.QueryValidationService;
import org.graylog.plugins.views.search.validation.ValidationMessage;
import org.graylog.plugins.views.search.validation.ValidationRequest;
import org.graylog.plugins.views.search.validation.ValidationResponse;
import org.graylog.plugins.views.search.validation.ValidationStatus;
import org.graylog.plugins.views.search.validation.ValidationType;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.streams.StreamService;

@RequiresAuthentication
@Api(value="Search/Validation", tags={"cloud"})
@Path(value="/search/validate")
public class QueryValidationResource
extends RestResource
implements PluginRestResource {
    private final QueryValidationService queryValidationService;
    private final Optional<StreamQueryExplainer> optionalStreamQueryExplainer;
    private final IndexLookup indexLookup;
    private final StreamService streamService;

    @Inject
    public QueryValidationResource(QueryValidationService queryValidationService, Optional<StreamQueryExplainer> optionalStreamQueryExplainer, IndexLookup indexLookup, StreamService streamService) {
        this.queryValidationService = queryValidationService;
        this.optionalStreamQueryExplainer = optionalStreamQueryExplainer;
        this.indexLookup = indexLookup;
        this.streamService = streamService;
    }

    @POST
    @Produces(value={"application/json"})
    @ApiOperation(value="Validate a search query")
    @NoAuditEvent(value="Only validating query structure, not changing any data")
    public ValidationResponseDTO validateQuery(@ApiParam(name="validationRequest") ValidationRequestDTO validationRequest, @Context SearchUser searchUser) {
        Set<String> readableStreams;
        ValidationRequest request = this.prepareRequest(validationRequest, searchUser);
        ValidationResponse response = this.queryValidationService.validate(request);
        Set<ExplainResults.IndexRangeResult> searchedIndexRanges = this.indexRanges(request);
        Optional<Set<String>> requestedStreams = validationRequest.streams();
        Set<DataRoutedStream> dataRoutedStreams = this.checkForDataRoutedStreams(requestedStreams, readableStreams = request.streams(), request.timerange(), request.isEmptyQuery());
        boolean hasDataRoutedStreams = dataRoutedStreams != null && !dataRoutedStreams.isEmpty();
        Optional<TimeRange> requestedRangeAsAbsolut = validationRequest.timerange().map(timeRange -> AbsoluteRange.create(timeRange.getFrom(), timeRange.getTo()));
        return ValidationResponseDTO.create(this.toStatus(response.status(), this.containsWarmIndices(searchedIndexRanges), hasDataRoutedStreams), this.toExplanations(response), searchedIndexRanges, dataRoutedStreams, requestedRangeAsAbsolut);
    }

    private boolean containsWarmIndices(Set<ExplainResults.IndexRangeResult> searchedIndexRanges) {
        return searchedIndexRanges.stream().anyMatch(ExplainResults.IndexRangeResult::isWarmTiered);
    }

    Set<DataRoutedStream> checkForDataRoutedStreams(Optional<Set<String>> requestedStreams, Set<String> readableStreams, TimeRange timeRange, boolean isEmptyQuery) {
        return this.optionalStreamQueryExplainer.map(streamQueryExplainer -> {
            Instant from = timeRange.getFrom().toInstant().toDate().toInstant();
            Instant to = timeRange.getTo().toInstant().toDate().toInstant();
            StreamQueryInfo query = new StreamQueryInfo(requestedStreams, readableStreams, from, to, isEmptyQuery);
            return this.optionalStreamQueryExplainer.get().explain(query);
        }).orElse(Set.of());
    }

    private ValidationRequest prepareRequest(ValidationRequestDTO validationRequest, SearchUser searchUser) {
        Set streamsAndMappedCategories = validationRequest.streams().orElse(new HashSet());
        if (validationRequest.streamCategories().isPresent()) {
            streamsAndMappedCategories.addAll(searchUser.streams().loadStreamsWithCategories(validationRequest.streamCategories().get()));
        }
        ImmutableSet.Builder allRequestedStreams = ImmutableSet.builder().addAll(searchUser.streams().readableOrAllIfEmpty(streamsAndMappedCategories));
        ValidationRequest.Builder q = ValidationRequest.Builder.builder().query(validationRequest.query()).timerange(validationRequest.timerange().orElse(this.defaultTimeRange())).streams((Set<String>)allRequestedStreams.build()).parameters(this.resolveParameters(validationRequest)).validationMode(validationRequest.validationMode().toInternalRepresentation());
        validationRequest.filter().ifPresent(q::filter);
        return q.build();
    }

    private Set<ExplainResults.IndexRangeResult> indexRanges(ValidationRequest request) {
        Set streamTitles = request.streams().stream().map(this.streamService::streamTitleFromCache).filter(Objects::nonNull).collect(Collectors.toSet());
        return this.indexLookup.indexRangesForStreamsInTimeRange(request.streams(), request.timerange()).stream().map(indexRange -> ExplainResults.IndexRangeResult.fromIndexRange(indexRange, streamTitles)).collect(Collectors.toSet());
    }

    private ImmutableSet<Parameter> resolveParameters(ValidationRequestDTO validationRequest) {
        return (ImmutableSet)validationRequest.parameters().stream().map(param -> param.applyBindings((Map<String, Parameter.Binding>)validationRequest.parameterBindings())).collect(ImmutableSet.toImmutableSet());
    }

    private ValidationStatusDTO toStatus(ValidationStatus status, boolean hasWarmIndices, boolean hasDataRoutedStreams) {
        boolean isOk;
        ValidationStatusDTO validationStatusDTO = switch (status) {
            case ValidationStatus.WARNING -> ValidationStatusDTO.WARNING;
            case ValidationStatus.ERROR -> ValidationStatusDTO.ERROR;
            default -> ValidationStatusDTO.OK;
        };
        boolean bl = isOk = validationStatusDTO == ValidationStatusDTO.OK;
        if (isOk && hasWarmIndices) {
            return ValidationStatusDTO.WARNING;
        }
        if (isOk && hasDataRoutedStreams) {
            return ValidationStatusDTO.INFO;
        }
        return validationStatusDTO;
    }

    private List<ValidationMessageDTO> toExplanations(ValidationResponse response) {
        return response.explanations().stream().map(this::toExplanation).sorted(Comparator.comparing(ValidationMessageDTO::beginLine, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(ValidationMessageDTO::beginColumn, Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList());
    }

    private ValidationMessageDTO toExplanation(ValidationMessage message) {
        ValidationTypeDTO validationType = this.convert(message.validationType());
        ValidationMessageDTO.Builder builder = ValidationMessageDTO.builder(validationType, message.errorMessage());
        message.relatedProperty().ifPresent(builder::relatedProperty);
        message.position().ifPresent(queryPosition -> {
            builder.beginLine(queryPosition.beginLine());
            builder.beginColumn(queryPosition.beginColumn());
            builder.endLine(queryPosition.endLine());
            builder.endColumn(queryPosition.endColumn());
        });
        return builder.build();
    }

    private ValidationTypeDTO convert(ValidationType validationType) {
        return ValidationTypeDTO.from(validationType);
    }

    private RelativeRange defaultTimeRange() {
        return RelativeRange.create(300);
    }
}

