/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.scheduler;

import jakarta.inject.Inject;
import java.util.Optional;
import org.graylog.scheduler.JobSchedule;
import org.graylog.scheduler.JobTriggerDto;
import org.graylog.scheduler.clock.JobSchedulerClock;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobScheduleStrategies {
    private static final Logger LOG = LoggerFactory.getLogger(JobScheduleStrategies.class);
    private final JobSchedulerClock clock;

    @Inject
    public JobScheduleStrategies(JobSchedulerClock clock) {
        this.clock = clock;
    }

    public Optional<DateTime> nextTime(JobTriggerDto trigger) {
        return this.nextTime(trigger, trigger.nextTime());
    }

    public Optional<DateTime> nextTime(JobTriggerDto trigger, DateTime date) {
        return trigger.schedule().calculateNextTime(trigger.lock().lastLockTime(), date, this.clock);
    }

    public Optional<DateTime> nextFutureTime(JobTriggerDto trigger) {
        DateTime now = this.clock.nowUTC();
        DateTime lastNextTime = trigger.nextTime();
        DateTime lastExecutionTime = trigger.lock().lastLockTime();
        JobSchedule schedule = trigger.schedule();
        Optional<DateTime> optionalNextTime = schedule.calculateNextTime(lastExecutionTime, lastNextTime, this.clock);
        if (!optionalNextTime.isPresent()) {
            return Optional.empty();
        }
        DateTime nextTime = optionalNextTime.get();
        while (!nextTime.isAfter((ReadableInstant)now)) {
            LOG.debug("New nextTime <{}> is in the past, re-calculating again", (Object)nextTime);
            if ((nextTime = (DateTime)schedule.calculateNextTime(lastExecutionTime, nextTime, this.clock).orElse(null)) != null) continue;
            return Optional.empty();
        }
        return Optional.of(nextTime);
    }
}

