/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.scheduler;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog.scheduler.AutoValue_JobTriggerDto;
import org.graylog.scheduler.JobSchedule;
import org.graylog.scheduler.JobTriggerData;
import org.graylog.scheduler.JobTriggerLock;
import org.graylog.scheduler.JobTriggerStatus;
import org.graylog.scheduler.clock.JobSchedulerClock;
import org.graylog.scheduler.clock.JobSchedulerSystemClock;
import org.graylog2.database.MongoEntity;
import org.joda.time.DateTime;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@JsonDeserialize(builder=Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@AutoValue
public abstract class JobTriggerDto
implements MongoEntity {
    public static final String FIELD_ID = "id";
    public static final String FIELD_JOB_DEFINITION_TYPE = "job_definition_type";
    public static final String FIELD_JOB_DEFINITION_ID = "job_definition_id";
    static final String FIELD_START_TIME = "start_time";
    static final String FIELD_END_TIME = "end_time";
    static final String FIELD_NEXT_TIME = "next_time";
    static final String FIELD_EXECUTION_DURATION = "execution_duration";
    private static final String FIELD_CREATED_AT = "created_at";
    static final String FIELD_UPDATED_AT = "updated_at";
    static final String FIELD_TRIGGERED_AT = "triggered_at";
    public static final String FIELD_STATUS = "status";
    static final String FIELD_LOCK = "lock";
    static final String FIELD_SCHEDULE = "schedule";
    public static final String FIELD_DATA = "data";
    static final String FIELD_CONSTRAINTS = "constraints";
    public static final String FIELD_IS_CANCELLED = "is_cancelled";
    public static final String FIELD_CONCURRENCY_RESCHEDULE_COUNT = "concurrency_reschedule_count";

    @Override
    @Id
    @ObjectId
    @Nullable
    @JsonProperty(value="id")
    public abstract String id();

    @JsonProperty(value="job_definition_type")
    public abstract String jobDefinitionType();

    @JsonProperty(value="job_definition_id")
    public abstract String jobDefinitionId();

    @JsonProperty(value="start_time")
    public abstract DateTime startTime();

    @JsonProperty(value="end_time")
    public abstract Optional<DateTime> endTime();

    @JsonProperty(value="next_time")
    public abstract DateTime nextTime();

    @JsonProperty(value="created_at")
    public abstract DateTime createdAt();

    @JsonProperty(value="updated_at")
    public abstract DateTime updatedAt();

    @JsonProperty(value="triggered_at")
    public abstract Optional<DateTime> triggeredAt();

    @JsonProperty(value="execution_duration")
    public abstract Optional<Long> executionDurationMs();

    @JsonProperty(value="status")
    public abstract JobTriggerStatus status();

    @JsonProperty(value="lock")
    public abstract JobTriggerLock lock();

    @JsonProperty(value="schedule")
    public abstract JobSchedule schedule();

    @JsonProperty(value="data")
    public abstract Optional<JobTriggerData> data();

    @JsonProperty(value="constraints")
    public abstract Set<String> constraints();

    @JsonProperty(value="is_cancelled")
    public abstract boolean isCancelled();

    @JsonProperty(value="concurrency_reschedule_count")
    public abstract int concurrencyRescheduleCount();

    public static Builder builder() {
        return Builder.create();
    }

    public static Builder builderWithClock(JobSchedulerClock clock) {
        return Builder.create(clock);
    }

    public abstract Builder toBuilder();

    @JsonIgnoreProperties(ignoreUnknown=true)
    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return Builder.create(new JobSchedulerSystemClock());
        }

        public static Builder create(JobSchedulerClock clock) {
            DateTime now = clock.nowUTC();
            return new AutoValue_JobTriggerDto.Builder().startTime(now).createdAt(now).updatedAt(now).nextTime(now).status(JobTriggerStatus.RUNNABLE).isCancelled(false).concurrencyRescheduleCount(0).constraints((Set<String>)ImmutableSet.of()).lock(JobTriggerLock.empty());
        }

        @Id
        @ObjectId
        @JsonProperty(value="id")
        public abstract Builder id(String var1);

        @JsonProperty(value="job_definition_type")
        public abstract Builder jobDefinitionType(String var1);

        @JsonProperty(value="job_definition_id")
        public abstract Builder jobDefinitionId(String var1);

        @JsonProperty(value="start_time")
        public abstract Builder startTime(DateTime var1);

        @JsonProperty(value="end_time")
        public abstract Builder endTime(@Nullable DateTime var1);

        @JsonProperty(value="next_time")
        public abstract Builder nextTime(DateTime var1);

        @JsonProperty(value="created_at")
        public abstract Builder createdAt(DateTime var1);

        @JsonProperty(value="updated_at")
        public abstract Builder updatedAt(DateTime var1);

        @JsonProperty(value="triggered_at")
        public abstract Builder triggeredAt(@Nullable DateTime var1);

        @JsonProperty(value="execution_duration")
        public abstract Builder executionDurationMs(@Nullable Long var1);

        @JsonProperty(value="status")
        public abstract Builder status(JobTriggerStatus var1);

        @JsonProperty(value="lock")
        public abstract Builder lock(JobTriggerLock var1);

        @JsonProperty(value="schedule")
        public abstract Builder schedule(JobSchedule var1);

        @JsonProperty(value="data")
        public abstract Builder data(@Nullable JobTriggerData var1);

        @JsonProperty(value="constraints")
        public abstract Builder constraints(Set<String> var1);

        @JsonProperty(value="is_cancelled")
        public abstract Builder isCancelled(boolean var1);

        @JsonProperty(value="concurrency_reschedule_count")
        public abstract Builder concurrencyRescheduleCount(int var1);

        public abstract JobTriggerDto build();
    }
}

