/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authservice.rest;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresGuest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.security.authservice.AuthServiceBackendDTO;
import org.graylog.security.authservice.AuthServiceBackendUsageCheck;
import org.graylog.security.authservice.DBAuthServiceBackendService;
import org.graylog.security.authservice.GlobalAuthServiceConfig;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.database.PaginatedList;
import org.graylog2.plugin.rest.ValidationFailureException;
import org.graylog2.plugin.rest.ValidationResult;
import org.graylog2.rest.PaginationParameters;
import org.graylog2.rest.models.PaginatedResponse;
import org.graylog2.search.SearchQuery;
import org.graylog2.search.SearchQueryField;
import org.graylog2.search.SearchQueryParser;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.users.PaginatedUserService;
import org.graylog2.users.RoleService;
import org.graylog2.users.UserOverviewDTO;

@Path(value="/system/authentication/services/backends")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="System/Authentication/Services/Backends", description="Manage authentication service backends")
@RequiresAuthentication
public class AuthServiceBackendsResource
extends RestResource {
    private static final ImmutableMap<String, SearchQueryField> SEARCH_FIELD_MAPPING = ImmutableMap.builder().put((Object)"username", (Object)SearchQueryField.create("username")).put((Object)"full_name", (Object)SearchQueryField.create("full_name")).put((Object)"email", (Object)SearchQueryField.create("email")).build();
    private final DBAuthServiceBackendService dbService;
    private final GlobalAuthServiceConfig globalAuthServiceConfig;
    private final PaginatedUserService userService;
    private final RoleService roleService;
    private final AuthServiceBackendUsageCheck usageCheck;
    private final SearchQueryParser userSearchQueryParser;

    @Inject
    public AuthServiceBackendsResource(DBAuthServiceBackendService dbService, GlobalAuthServiceConfig globalAuthServiceConfig, PaginatedUserService userService, RoleService roleService, AuthServiceBackendUsageCheck usageCheck) {
        this.dbService = dbService;
        this.globalAuthServiceConfig = globalAuthServiceConfig;
        this.userService = userService;
        this.roleService = roleService;
        this.usageCheck = usageCheck;
        this.userSearchQueryParser = new SearchQueryParser("full_name", (Map<String, SearchQueryField>)SEARCH_FIELD_MAPPING);
    }

    @GET
    @RequiresGuest
    @Path(value="active-backend/type")
    @ApiOperation(value="Returns type of currently active authentication service backend")
    public Response getActiveType() {
        String type = null;
        AuthServiceBackendDTO activeBackendConfig = this.globalAuthServiceConfig.getActiveBackendConfig().orElse(null);
        if (activeBackendConfig != null) {
            type = activeBackendConfig.config().type();
        }
        return this.toResponse(type);
    }

    @GET
    @ApiOperation(value="Returns available authentication service backends")
    public PaginatedResponse<AuthServiceBackendDTO> list(@ApiParam(name="pagination parameters") @BeanParam PaginationParameters paginationParameters) {
        AuthServiceBackendDTO activeBackendConfig = this.globalAuthServiceConfig.getActiveBackendConfig().filter(this::checkReadPermission).orElse(null);
        PaginatedList<AuthServiceBackendDTO> list = this.dbService.findPaginated(paginationParameters, this::checkReadPermission);
        return PaginatedResponse.create("backends", list, Collections.singletonMap("active_backend", activeBackendConfig));
    }

    @GET
    @Path(value="{backendId}")
    @ApiOperation(value="Returns the authentication service backend for the given ID")
    public Response get(@ApiParam(name="backendId", required=true) @PathParam(value="backendId") @NotBlank String backendId) {
        this.checkPermission("authservicebackend:read", backendId);
        return this.toResponse(this.loadConfig(backendId));
    }

    @POST
    @ApiOperation(value="Creates a new authentication service backend")
    @RequiresPermissions(value={"authservicebackend:create"})
    @AuditEvent(type="security:auth_service_backend:create")
    public Response create(@ApiParam(name="JSON body", required=true) @NotNull AuthServiceBackendDTO newConfig) {
        this.validateConfig(newConfig);
        return this.toResponse(this.dbService.save(newConfig));
    }

    @PUT
    @Path(value="{backendId}")
    @ApiOperation(value="Updates an existing authentication service backend")
    @AuditEvent(type="security:auth_service_backend:update")
    public Response update(@ApiParam(name="backendId", required=true) @PathParam(value="backendId") @NotBlank String backendId, @ApiParam(name="JSON body", required=true) @NotNull AuthServiceBackendDTO updatedConfig) {
        this.checkPermission("authservicebackend:edit", backendId);
        this.validateConfig(updatedConfig);
        AuthServiceBackendDTO currentConfig = this.loadConfig(backendId);
        return this.toResponse(this.dbService.save(updatedConfig.withId(currentConfig.id())));
    }

    @DELETE
    @Path(value="{backendId}")
    @ApiOperation(value="Delete authentication service backend")
    @AuditEvent(type="security:auth_service_backend:delete")
    public void delete(@ApiParam(name="backendId", required=true) @PathParam(value="backendId") @NotBlank String backendId) {
        this.checkPermission("authservicebackend:delete", backendId);
        AuthServiceBackendDTO config = this.loadConfig(backendId);
        if (this.usageCheck.isAuthServiceInUse(backendId)) {
            throw new BadRequestException("Authentication service backend <" + backendId + "> is still in use");
        }
        this.dbService.delete(config.id());
    }

    @GET
    @Path(value="{backendId}/users")
    @ApiOperation(value="Get paginated users for an authentication service backend")
    @RequiresPermissions(value={"authserviceglobalconfig:read", "users:read"})
    public PaginatedResponse<UserOverviewDTO> getUsers(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="query") @QueryParam(value="query") @DefaultValue(value="") String query, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="username,full_name,email") @DefaultValue(value="full_name") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="asc") @QueryParam(value="order") String order, @ApiParam(name="backendId", required=true) @PathParam(value="backendId") @NotBlank String backendId) {
        AuthServiceBackendDTO activeConfig = this.loadConfig(backendId);
        PaginatedList<UserOverviewDTO> userList = this.userService.findPaginatedByAuthServiceBackend(this.parseSearchQuery(query), page, perPage, sort, order, activeConfig.id());
        return PaginatedResponse.create("users", userList, query, Collections.singletonMap("roles", this.createRoleContext((List<UserOverviewDTO>)userList.delegate())));
    }

    private Map<String, Object> createRoleContext(List<UserOverviewDTO> userList) {
        Set<String> roleIds = userList.stream().flatMap(user -> user.roles().stream()).collect(Collectors.toSet());
        try {
            return this.roleService.findIdMap(roleIds).values().stream().map(role -> {
                String roleName = this.isPermitted("roles:read", role.getId()) ? role.getName() : "unknown";
                return Maps.immutableEntry((Object)role.getId(), Collections.singletonMap("title", roleName));
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        catch (org.graylog2.database.NotFoundException e) {
            throw new NotFoundException("Couldn't find roles: " + roleIds);
        }
    }

    private SearchQuery parseSearchQuery(String query) {
        try {
            return this.userSearchQueryParser.parse(query);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Invalid argument in search query: " + e.getMessage());
        }
    }

    private boolean checkReadPermission(AuthServiceBackendDTO config) {
        return this.isPermitted("authservicebackend:read", config.id());
    }

    private AuthServiceBackendDTO loadConfig(String backendId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)backendId) ? 1 : 0) != 0, (Object)"backendId cannot be null or empty");
        return (AuthServiceBackendDTO)this.dbService.get(backendId).orElseThrow(() -> new NotFoundException("Couldn't find auth service backend " + backendId));
    }

    private void validateConfig(AuthServiceBackendDTO config) {
        ValidationResult result = config.validate();
        if (result.failed()) {
            throw new ValidationFailureException(result);
        }
    }

    private Response toResponse(Object entity) {
        return Response.ok(Collections.singletonMap("backend", entity)).build();
    }
}

