/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.graylog.scheduler.DBJobTriggerService;
import org.graylog.scheduler.JobTriggerDto;
import org.graylog.scheduler.clock.JobSchedulerClock;
import org.graylog.security.certutil.CaKeystore;
import org.graylog.security.certutil.CertRenewalService;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.nodes.DataNodeDto;
import org.graylog2.cluster.nodes.NodeService;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.certificates.RenewalPolicy;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Singleton
public class CertRenewalServiceImpl
implements CertRenewalService {
    private static final Logger LOG = LoggerFactory.getLogger(CertRenewalServiceImpl.class);
    private final ClusterConfigService clusterConfigService;
    private final NodeService<DataNodeDto> nodeService;
    private final NotificationService notificationService;
    private final DBJobTriggerService jobTriggerService;
    private final JobSchedulerClock clock;
    private final CaKeystore caKeystore;

    @Inject
    public CertRenewalServiceImpl(ClusterConfigService clusterConfigService, NodeService<DataNodeDto> nodeService, NotificationService notificationService, DBJobTriggerService jobTriggerService, JobSchedulerClock clock, CaKeystore caKeystore) {
        this.clusterConfigService = clusterConfigService;
        this.nodeService = nodeService;
        this.notificationService = notificationService;
        this.jobTriggerService = jobTriggerService;
        this.clock = clock;
        this.caKeystore = caKeystore;
    }

    private Optional<RenewalPolicy> getRenewalPolicy() {
        return Optional.ofNullable(this.clusterConfigService.get(RenewalPolicy.class));
    }

    boolean needsRenewal(DateTime nextRenewal, RenewalPolicy renewalPolicy, Date cert) {
        Date threshold = this.calculateThreshold(renewalPolicy);
        return threshold.after(cert) || nextRenewal.toDate().after(cert);
    }

    Date convertToDateViaInstant(LocalDateTime dateToConvert) {
        return Date.from(dateToConvert.atZone(ZoneId.systemDefault()).toInstant());
    }

    Date calculateThreshold(RenewalPolicy renewalPolicy) {
        Duration threshold = renewalPolicy.getRenewalThreshold();
        LocalDateTime validUntil = this.clock.now(ZoneId.systemDefault()).plus(threshold).toLocalDateTime();
        return this.convertToDateViaInstant(validUntil);
    }

    @Override
    public void checkCertificatesForRenewal() {
        this.getRenewalPolicy().ifPresent(renewalPolicy -> {
            this.checkDataNodesCertificatesForRenewal((RenewalPolicy)renewalPolicy);
            this.checkCaCertificatesForRenewal((RenewalPolicy)renewalPolicy);
        });
    }

    private DateTime getNextRenewal() {
        return this.jobTriggerService.getOneForJob("64a66741cb3275652764c937").map(JobTriggerDto::nextTime).orElse(DateTime.now((DateTimeZone)DateTimeZone.UTC).plusMinutes(30));
    }

    protected void checkCaCertificatesForRenewal(RenewalPolicy renewalPolicy) {
        DateTime nextRenewal;
        Optional<Date> expiration = this.caKeystore.getCertificateExpiration();
        if (expiration.isPresent() && this.needsRenewal(nextRenewal = this.getNextRenewal(), renewalPolicy, expiration.get())) {
            this.notificationService.fixed(Notification.Type.CERTIFICATE_NEEDS_RENEWAL, "ca cert");
        }
    }

    protected List<DataNodeDto> findNodesThatNeedCertificateRenewal(RenewalPolicy renewalPolicy) {
        DateTime nextRenewal = this.getNextRenewal();
        Map<String, DataNodeDto> activeDataNodes = this.nodeService.allActive();
        return activeDataNodes.values().stream().filter(node -> node.getCertValidUntil() != null).filter(node -> {
            Date nowPlusThreshold = this.calculateThreshold(renewalPolicy);
            return nowPlusThreshold.after(node.getCertValidUntil()) || nextRenewal.toDate().after(node.getCertValidUntil());
        }).toList();
    }

    private void notifyManualRenewalForNode(List<DataNodeDto> nodes) {
        String key = String.join((CharSequence)",", nodes.stream().map(Node::getNodeId).toList());
        if (!this.notificationService.isFirst(Notification.Type.CERTIFICATE_NEEDS_RENEWAL)) {
            this.notificationService.fixed(Notification.Type.CERTIFICATE_NEEDS_RENEWAL);
        }
        Notification notification = this.notificationService.buildNow().addType(Notification.Type.CERTIFICATE_NEEDS_RENEWAL).addSeverity(Notification.Severity.URGENT).addKey(key).addDetail("nodes", key);
        this.notificationService.publishIfFirst(notification);
    }

    protected void checkDataNodesCertificatesForRenewal(RenewalPolicy renewalPolicy) {
        List<DataNodeDto> nodes;
        if (RenewalPolicy.Mode.MANUAL.equals((Object)renewalPolicy.mode()) && !(nodes = this.findNodesThatNeedCertificateRenewal(renewalPolicy)).isEmpty()) {
            this.notifyManualRenewalForNode(nodes);
        }
    }
}

