/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.graylog.security.certutil.CaKeystore;
import org.graylog.security.certutil.CaKeystoreException;
import org.graylog.security.certutil.ca.exceptions.KeyStoreStorageException;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.bootstrap.preflight.web.resources.model.CertificateAuthorityInformation;
import org.graylog2.bootstrap.preflight.web.resources.model.CreateCARequest;
import org.graylog2.plugin.rest.ApiError;
import org.graylog2.shared.rest.resources.RestResource;

@Path(value="/ca")
@Produces(value={"application/json"})
@RequiresAuthentication
@Api(value="CA", description="Certificate Authority", tags={"cloud"})
public class CAResource
extends RestResource {
    private final CaKeystore caKeystore;

    @Inject
    public CAResource(CaKeystore caKeystore) {
        this.caKeystore = caKeystore;
    }

    @GET
    @ApiOperation(value="Returns the CA")
    @RequiresPermissions(value={"graylog_ca:read"})
    public CertificateAuthorityInformation get() throws KeyStoreStorageException {
        return this.caKeystore.getInformation().orElse(null);
    }

    @POST
    @Path(value="create")
    @AuditEvent(type="graylog_ca:ca:create")
    @ApiOperation(value="Creates a CA")
    @RequiresPermissions(value={"graylog_ca:create"})
    public Response createCA(@ApiParam(name="request", required=true) @NotNull @Valid CreateCARequest request) {
        CertificateAuthorityInformation ca = this.caKeystore.createSelfSigned(request.organization());
        URI caUri = this.getUriBuilderToSelf().path(CAResource.class).build(new Object[0]);
        return Response.created((URI)caUri).entity((Object)ca).build();
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="upload")
    @AuditEvent(type="graylog_ca:ca:upload")
    @ApiOperation(value="Upload a CA")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"graylog_ca:create"})
    public Response uploadCA(@ApiParam(name="password") @FormDataParam(value="password") String password, @ApiParam(name="files") @FormDataParam(value="files") List<FormDataBodyPart> files) {
        try {
            this.caKeystore.createFromUpload(password, files);
            return Response.ok().build();
        }
        catch (CaKeystoreException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ApiError.create(e.getMessage())).build();
        }
    }
}

