/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.preflight;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import org.graylog.security.certutil.CaKeystore;
import org.graylog2.bootstrap.preflight.GraylogCertificateProvisioner;
import org.graylog2.cluster.certificates.CertificateExchange;
import org.graylog2.cluster.certificates.CertificateSigningRequest;
import org.graylog2.plugin.certificates.RenewalPolicy;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GraylogCertificateProvisionerImpl
implements GraylogCertificateProvisioner {
    private static final Logger LOG = LoggerFactory.getLogger(GraylogCertificateProvisionerImpl.class);
    private final CaKeystore caKeystore;
    private final ClusterConfigService clusterConfigService;
    private final CertificateExchange certificateExchange;

    @Inject
    public GraylogCertificateProvisionerImpl(CaKeystore caKeystore, ClusterConfigService clusterConfigService, CertificateExchange certificateExchange) {
        this.caKeystore = caKeystore;
        this.clusterConfigService = clusterConfigService;
        this.certificateExchange = certificateExchange;
    }

    @Override
    public void runProvisioning() {
        try {
            if (!this.caKeystore.exists()) {
                LOG.debug("No CA keystore available.");
                return;
            }
            RenewalPolicy renewalPolicy = this.getRenewalPolicy();
            if (renewalPolicy == null) {
                LOG.debug("No renewal policy available.");
                return;
            }
            this.certificateExchange.signPendingCertificateRequests(request -> this.caKeystore.signCertificateRequest((CertificateSigningRequest)request, renewalPolicy));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private RenewalPolicy getRenewalPolicy() {
        return this.clusterConfigService.get(RenewalPolicy.class);
    }
}

