/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.cluster.nodes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.github.zafarkhaja.semver.Version;
import com.google.auto.value.AutoValue;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.graylog.security.certutil.CertRenewalService;
import org.graylog2.cluster.nodes.AutoValue_DataNodeDto;
import org.graylog2.cluster.nodes.DataNodeStatus;
import org.graylog2.cluster.nodes.NodeDto;
import org.graylog2.cluster.preflight.DataNodeProvisioningConfig;
import org.graylog2.datanode.DataNodeLifecycleTrigger;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(as=DataNodeDto.class)
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class DataNodeDto
extends NodeDto {
    public static final String FIELD_CERT_VALID_UNTIL = "cert_valid_until";
    public static final String FIELD_DATANODE_VERSION = "datanode_version";

    @Nullable
    @JsonProperty(value="cluster_address")
    public abstract String getClusterAddress();

    @Nullable
    @JsonProperty(value="rest_api_address")
    public abstract String getRestApiAddress();

    @JsonProperty(value="data_node_status")
    public abstract DataNodeStatus getDataNodeStatus();

    @Nullable
    @JsonProperty(value="action_queue")
    public abstract DataNodeLifecycleTrigger getActionQueue();

    @Nullable
    @JsonProperty(value="cert_valid_until")
    public abstract Date getCertValidUntil();

    @Nullable
    @JsonProperty(value="datanode_version")
    public abstract String getDatanodeVersion();

    @JsonProperty(value="version_compatible")
    public boolean isCompatibleWithVersion() {
        return this.getDatanodeVersion() != null && org.graylog2.plugin.Version.CURRENT_CLASSPATH.compareTo(new org.graylog2.plugin.Version(Version.valueOf((String)this.getDatanodeVersion()))) == 0;
    }

    @Nullable
    @JsonUnwrapped
    public CertRenewalService.ProvisioningInformation getProvisioningInformation() {
        DataNodeProvisioningConfig.State state = switch (this.getDataNodeStatus()) {
            case DataNodeStatus.AVAILABLE -> DataNodeProvisioningConfig.State.CONNECTED;
            case DataNodeStatus.STARTING -> DataNodeProvisioningConfig.State.STARTING;
            case DataNodeStatus.PREPARED -> DataNodeProvisioningConfig.State.PROVISIONED;
            default -> DataNodeProvisioningConfig.State.UNCONFIGURED;
        };
        LocalDateTime certValidTill = Optional.ofNullable(this.getCertValidUntil()).map(date -> Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime()).orElse(null);
        return new CertRenewalService.ProvisioningInformation(state, null, certValidTill);
    }

    @Override
    public Map<String, Object> toEntityParameters() {
        Map<String, Object> params = super.toEntityParameters();
        if (Objects.nonNull(this.getClusterAddress())) {
            params.put("cluster_address", this.getClusterAddress());
        }
        if (Objects.nonNull(this.getRestApiAddress())) {
            params.put("rest_api_address", this.getRestApiAddress());
        }
        if (Objects.nonNull((Object)this.getDataNodeStatus())) {
            params.put("datanode_status", (Object)this.getDataNodeStatus());
        }
        if (Objects.nonNull((Object)this.getActionQueue())) {
            if (this.getActionQueue() == DataNodeLifecycleTrigger.CLEAR) {
                params.put("action_queue", null);
            } else {
                params.put("action_queue", (Object)this.getActionQueue());
            }
        }
        if (Objects.nonNull(this.getCertValidUntil())) {
            params.put(FIELD_CERT_VALID_UNTIL, this.getCertValidUntil());
        }
        if (Objects.nonNull(this.getDatanodeVersion())) {
            params.put(FIELD_DATANODE_VERSION, this.getDatanodeVersion());
        }
        return params;
    }

    public abstract Builder toBuilder();

    @JsonIgnoreProperties(ignoreUnknown=true)
    @AutoValue.Builder
    public static abstract class Builder
    extends NodeDto.Builder<Builder> {
        @JsonCreator
        public static Builder builder() {
            return new AutoValue_DataNodeDto.Builder().setLeader(false);
        }

        @JsonProperty(value="cluster_address")
        public abstract Builder setClusterAddress(String var1);

        @JsonProperty(value="rest_api_address")
        public abstract Builder setRestApiAddress(String var1);

        @JsonProperty(value="datanode_status")
        public abstract Builder setDataNodeStatus(DataNodeStatus var1);

        @JsonProperty(value="action_queue")
        public abstract Builder setActionQueue(DataNodeLifecycleTrigger var1);

        @JsonProperty(value="cert_valid_until")
        public abstract Builder setCertValidUntil(Date var1);

        @JsonProperty(value="datanode_version")
        public abstract Builder setDatanodeVersion(String var1);

        public abstract DataNodeDto build();
    }
}

