/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration;

import jakarta.inject.Inject;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.datatiering.DataTieringConfig;
import org.graylog2.datatiering.hotonly.HotOnlyDataTieringConfig;
import org.graylog2.indexer.indexset.SimpleIndexSetConfig;
import org.graylog2.indexer.indexset.template.IndexSetTemplateConfig;
import org.graylog2.indexer.rotation.strategies.TimeBasedSizeOptimizingStrategyConfig;
import org.graylog2.migrations.MaintenanceStrategiesHelper;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;

public class IndexSetDefaultTemplateConfigFactory {
    private final ElasticsearchConfiguration elasticsearchConfiguration;
    private final MaintenanceStrategiesHelper maintenanceStrategiesHelper;

    @Inject
    public IndexSetDefaultTemplateConfigFactory(ElasticsearchConfiguration elasticsearchConfiguration, MaintenanceStrategiesHelper maintenanceStrategiesHelper) {
        this.elasticsearchConfiguration = elasticsearchConfiguration;
        this.maintenanceStrategiesHelper = maintenanceStrategiesHelper;
    }

    public IndexSetTemplateConfig create() {
        ImmutablePair<String, RotationStrategyConfig> rotationConfig = this.maintenanceStrategiesHelper.readRotationConfigFromServerConf();
        ImmutablePair<String, RetentionStrategyConfig> retentionConfig = this.maintenanceStrategiesHelper.readRetentionConfigFromServerConf();
        return IndexSetTemplateConfig.builder().indexAnalyzer(this.elasticsearchConfiguration.getAnalyzer()).shards(this.elasticsearchConfiguration.getShards()).replicas(this.elasticsearchConfiguration.getReplicas()).indexOptimizationDisabled(this.elasticsearchConfiguration.isDisableIndexOptimization()).indexOptimizationMaxNumSegments(this.elasticsearchConfiguration.getIndexOptimizationMaxNumSegments()).fieldTypeRefreshInterval(SimpleIndexSetConfig.DEFAULT_FIELD_TYPE_REFRESH_INTERVAL).rotationStrategyClass((String)rotationConfig.left).rotationStrategyConfig((RotationStrategyConfig)rotationConfig.right).retentionStrategyClass((String)retentionConfig.left).retentionStrategyConfig((RetentionStrategyConfig)retentionConfig.right).useLegacyRotation(false).dataTieringConfig(this.maintenanceStrategiesHelper.defaultDataTieringConfig()).build();
    }

    public DataTieringConfig getDataTieringConfig(RotationStrategyConfig rotationStrategyConfig) {
        if (rotationStrategyConfig instanceof TimeBasedSizeOptimizingStrategyConfig) {
            TimeBasedSizeOptimizingStrategyConfig config = (TimeBasedSizeOptimizingStrategyConfig)rotationStrategyConfig;
            return HotOnlyDataTieringConfig.builder().indexLifetimeMin(config.indexLifetimeMin()).indexLifetimeMax(config.indexLifetimeMax()).build();
        }
        return this.maintenanceStrategiesHelper.defaultDataTieringConfig();
    }
}

