/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.client.MongoCollection;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.bson.codecs.configuration.CodecRegistry;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.MongoEntity;
import org.graylog2.database.entities.EntityScopeService;
import org.graylog2.database.entities.ScopedEntity;
import org.graylog2.database.jackson.CustomJacksonCodecRegistry;
import org.graylog2.database.pagination.DefaultMongoPaginationHelper;
import org.graylog2.database.pagination.MongoPaginationHelper;
import org.graylog2.database.utils.MongoUtils;
import org.graylog2.database.utils.ScopedEntityMongoUtils;

@Singleton
public class MongoCollections {
    private final ObjectMapper objectMapper;
    private final MongoConnection mongoConnection;

    @Inject
    public MongoCollections(MongoJackObjectMapperProvider objectMapperProvider, MongoConnection mongoConnection) {
        this.objectMapper = objectMapperProvider.get();
        this.mongoConnection = mongoConnection;
    }

    @Deprecated
    public <T> MongoCollection<T> get(String collectionName, Class<T> valueType) {
        return this.nonEntityCollection(collectionName, valueType);
    }

    public <T> MongoCollection<T> nonEntityCollection(String collectionName, Class<T> valueType) {
        return this.getCollection(collectionName, valueType);
    }

    public <T extends MongoEntity> MongoCollection<T> collection(String collectionName, Class<T> valueType) {
        return this.getCollection(collectionName, valueType);
    }

    public <T extends MongoEntity> MongoPaginationHelper<T> paginationHelper(String collectionName, Class<T> valueType) {
        return this.paginationHelper(this.collection(collectionName, valueType));
    }

    public <T extends MongoEntity> MongoPaginationHelper<T> paginationHelper(MongoCollection<T> collection) {
        return new DefaultMongoPaginationHelper<T>(collection);
    }

    public <T extends MongoEntity> MongoUtils<T> utils(String collectionName, Class<T> valueType) {
        return this.utils(this.collection(collectionName, valueType));
    }

    public <T extends MongoEntity> MongoUtils<T> utils(MongoCollection<T> collection) {
        return new MongoUtils<T>(collection, this.objectMapper);
    }

    public <T extends ScopedEntity> ScopedEntityMongoUtils<T> scopedEntityUtils(MongoCollection<T> collection, EntityScopeService entityScopeService) {
        return new ScopedEntityMongoUtils<T>(collection, entityScopeService);
    }

    private <T> MongoCollection<T> getCollection(String collectionName, Class<T> valueType) {
        MongoCollection collection = this.mongoConnection.getMongoDatabase().getCollection(collectionName, valueType);
        CustomJacksonCodecRegistry jacksonCodecRegistry = new CustomJacksonCodecRegistry(this.objectMapper, collection.getCodecRegistry());
        jacksonCodecRegistry.addCodecForClass(valueType);
        return collection.withCodecRegistry((CodecRegistry)jacksonCodecRegistry);
    }
}

