/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.dbcatalog;

import com.google.common.base.Stopwatch;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationInfoList;
import io.github.classgraph.AnnotationParameterValue;
import io.github.classgraph.AnnotationParameterValueList;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.LinkedList;
import org.graylog2.database.DbEntity;
import org.graylog2.database.dbcatalog.DbEntitiesCatalog;
import org.graylog2.database.dbcatalog.DbEntityCatalogEntry;
import org.graylog2.shared.plugins.ChainingClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbEntitiesScanner
implements Provider<DbEntitiesCatalog> {
    private static final Logger LOG = LoggerFactory.getLogger(DbEntitiesScanner.class);
    private final String[] packagesToScan;
    private final String[] packagesToExclude;
    private final ChainingClassLoader chainingClassLoader;

    @Inject
    public DbEntitiesScanner(ChainingClassLoader chainingClassLoader) {
        this.chainingClassLoader = chainingClassLoader;
        this.packagesToScan = new String[]{"org.graylog2", "org.graylog"};
        this.packagesToExclude = new String[]{"org.graylog.shaded", "org.graylog.storage", "org.graylog2.migrations"};
    }

    DbEntitiesScanner(String[] packagesToScan, String[] packagesToExclude) {
        this.chainingClassLoader = null;
        this.packagesToScan = packagesToScan;
        this.packagesToExclude = packagesToExclude;
    }

    public DbEntitiesCatalog get() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        DbEntitiesCatalog catalog = this.scan(this.packagesToScan, this.packagesToExclude, this.chainingClassLoader);
        stopwatch.stop();
        LOG.info("{} entities have been scanned and added to DB Entity Catalog, it took {}", (Object)catalog.size(), (Object)stopwatch);
        return catalog;
    }

    public DbEntitiesCatalog scan(String[] packagesToScan, String[] packagesToExclude, ChainingClassLoader chainingClassLoader) {
        LinkedList<DbEntityCatalogEntry> dbEntities = new LinkedList<DbEntityCatalogEntry>();
        ClassGraph classGraph = new ClassGraph().enableAnnotationInfo().acceptPackages(packagesToScan).rejectPackages(packagesToExclude).filterClasspathElements(classpathElementPathStr -> classpathElementPathStr.contains("graylog")).disableRuntimeInvisibleAnnotations();
        if (chainingClassLoader != null) {
            for (ClassLoader cl : chainingClassLoader.getClassLoaders()) {
                classGraph = classGraph.addClassLoader(cl);
            }
        }
        try (ScanResult scanResult = classGraph.scan();){
            String annotationName = DbEntity.class.getCanonicalName();
            ClassInfoList classInfoList = scanResult.getClassesWithAnnotation(annotationName);
            for (ClassInfo classInfo : classInfoList) {
                AnnotationInfoList annotations = classInfo.getAnnotationInfoRepeatable(annotationName);
                for (AnnotationInfo annotationInfo : annotations) {
                    AnnotationParameterValueList paramVals = annotationInfo.getParameterValues();
                    dbEntities.add(new DbEntityCatalogEntry(((AnnotationParameterValue)paramVals.get("collection")).getValue().toString(), ((AnnotationParameterValue)paramVals.get("titleField")).getValue().toString(), classInfo.loadClass(), ((AnnotationParameterValue)paramVals.get("readPermission")).getValue().toString()));
                }
            }
            DbEntitiesCatalog dbEntitiesCatalog = new DbEntitiesCatalog(dbEntities);
            return dbEntitiesCatalog;
        }
    }
}

