/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.filtering;

import com.cronutils.utils.Preconditions;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public record AttributeFilter(@JsonProperty(value="field") String field, @JsonProperty(value="value") List<String> value) {
    private static final String FIELD_FIELD = "field";
    private static final String FIELD_VALUE = "value";

    @JsonCreator
    public static AttributeFilter create(@JsonProperty(value="field") String field, @JsonProperty(value="value") @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY}) List<String> value) {
        Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0, (Object)"Value should not be empty.");
        return new AttributeFilter(field, value);
    }

    private String quoted(String value) {
        if (value.contains(" ")) {
            return "\"" + value + "\"";
        }
        return value;
    }

    @JsonIgnore
    public List<String> toQueryStrings() {
        return this.value.stream().map(v -> this.field + ":" + this.quoted((String)v)).toList();
    }
}

