/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.suggestions;

import com.google.common.base.Strings;
import com.google.common.collect.Streams;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.shiro.subject.Subject;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedList;
import org.graylog2.database.suggestions.EntitySuggestion;
import org.graylog2.database.suggestions.EntitySuggestionResponse;
import org.graylog2.database.suggestions.EntitySuggestionService;
import org.graylog2.database.utils.MongoUtils;
import org.graylog2.shared.security.EntityPermissionsUtils;

public class MongoEntitySuggestionService
implements EntitySuggestionService {
    private final MongoConnection mongoConnection;
    private final EntityPermissionsUtils permissionsUtils;

    @Inject
    public MongoEntitySuggestionService(MongoConnection mongoConnection, EntityPermissionsUtils permissionsUtils) {
        this.mongoConnection = mongoConnection;
        this.permissionsUtils = permissionsUtils;
    }

    private boolean addAdminToSuggestions(String collection, String valueColumn, boolean filterIsEmpty, String query) {
        return "users".equals(collection) && "username".equals(valueColumn) && (filterIsEmpty || "local:admin".contains(query.toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public EntitySuggestionResponse suggest(String collection, String valueColumn, String query, int page, int perPage, Subject subject) {
        MongoCollection mongoCollection = this.mongoConnection.getMongoDatabase().getCollection(collection);
        boolean filterIsEmpty = Strings.isNullOrEmpty((String)query);
        boolean isSpecialCollection = this.addAdminToSuggestions(collection, valueColumn, filterIsEmpty, query);
        boolean isFirstPageAndSpecialCollection = isSpecialCollection && page == 1;
        int fixNumberOfItemsToReadFromDB = isFirstPageAndSpecialCollection ? 1 : 0;
        Bson bsonFilter = !filterIsEmpty ? Filters.regex((String)valueColumn, (String)query, (String)"i") : Filters.empty();
        FindIterable resultWithoutPagination = mongoCollection.find(bsonFilter).projection(Projections.include((String[])new String[]{valueColumn})).sort(Sorts.ascending((String[])new String[]{valueColumn}));
        boolean userCanReadAllEntities = this.permissionsUtils.hasAllPermission(subject) || this.permissionsUtils.hasReadPermissionForWholeCollection(subject, collection);
        int skip = Math.max(0, (page - 1) * perPage - fixNumberOfItemsToReadFromDB);
        Predicate<Document> checkPermission = this.permissionsUtils.createPermissionCheck(subject, collection);
        Stream<Document> documents = userCanReadAllEntities ? this.mongoPaginate((FindIterable<Document>)resultWithoutPagination, perPage - fixNumberOfItemsToReadFromDB, skip) : this.paginateWithPermissionCheck((FindIterable<Document>)resultWithoutPagination, perPage - fixNumberOfItemsToReadFromDB, skip, checkPermission);
        List staticEntry = isFirstPageAndSpecialCollection ? List.of(new EntitySuggestion("local:admin", "admin")) : List.of();
        Stream<EntitySuggestion> suggestionsFromDB = documents.map(doc -> new EntitySuggestion(doc.getObjectId((Object)"_id").toString(), doc.getString((Object)valueColumn)));
        List<EntitySuggestion> suggestions = Streams.concat((Stream[])new Stream[]{staticEntry.stream(), suggestionsFromDB}).toList();
        long total = userCanReadAllEntities ? mongoCollection.countDocuments(bsonFilter) : MongoUtils.stream(mongoCollection.find(bsonFilter).projection(Projections.include((String[])new String[]{"_id"}))).filter(checkPermission).count();
        return new EntitySuggestionResponse(suggestions, PaginatedList.PaginationInfo.create((int)total, suggestions.size(), page, perPage));
    }

    private Stream<Document> paginateWithPermissionCheck(FindIterable<Document> result, int limit, int skip, Predicate<Document> checkPermission) {
        return MongoUtils.stream(result).filter(checkPermission).limit(limit).skip(skip);
    }

    private Stream<Document> mongoPaginate(FindIterable<Document> result, int limit, int skip) {
        return MongoUtils.stream(result.limit(limit).skip(skip));
    }
}

