/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.utils;

import com.mongodb.client.MongoCollection;
import java.util.Objects;
import java.util.Optional;
import org.bson.types.ObjectId;
import org.graylog2.database.entities.EntityScopeService;
import org.graylog2.database.entities.ScopedEntity;
import org.graylog2.database.utils.MongoUtils;

public class ScopedEntityMongoUtils<T extends ScopedEntity> {
    private final MongoCollection<T> collection;
    private final EntityScopeService entityScopeService;

    public ScopedEntityMongoUtils(MongoCollection<T> delegate, EntityScopeService entityScopeService) {
        this.collection = delegate;
        this.entityScopeService = entityScopeService;
    }

    public T update(T entity) {
        Objects.requireNonNull(entity.id());
        this.ensureValidScope(entity);
        this.ensureMutability(entity);
        this.collection.replaceOne(MongoUtils.idEq(Objects.requireNonNull(entity.id())), entity);
        return entity;
    }

    public String create(T entity) {
        this.ensureValidScope(entity);
        return MongoUtils.insertedIdAsString(this.collection.insertOne(entity));
    }

    public boolean deleteById(String id) {
        return this.deleteById(new ObjectId(id));
    }

    public boolean deleteById(ObjectId id) {
        ScopedEntity entity = Optional.ofNullable((ScopedEntity)this.collection.find(MongoUtils.idEq(id)).first()).orElseThrow(() -> new IllegalArgumentException("Entity not found"));
        this.ensureDeletability(entity);
        this.ensureMutability(entity);
        return this.collection.deleteOne(MongoUtils.idEq(id)).getDeletedCount() > 0L;
    }

    public final long forceDelete(String id) {
        return this.collection.deleteOne(MongoUtils.idEq(id)).getDeletedCount();
    }

    public final boolean isMutable(T scopedEntity) {
        Objects.requireNonNull(scopedEntity, "Entity must not be null");
        Optional<ScopedEntity> current = scopedEntity.id() == null ? Optional.empty() : Optional.ofNullable((ScopedEntity)this.collection.find(MongoUtils.idEq(scopedEntity.id())).first());
        return current.map(t -> this.entityScopeService.isMutable((ScopedEntity)t, (ScopedEntity)scopedEntity)).orElseGet(() -> this.entityScopeService.isMutable((ScopedEntity)scopedEntity));
    }

    public final boolean isDeletable(T scopedEntity) {
        Objects.requireNonNull(scopedEntity, "Entity must not be null");
        Optional<ScopedEntity> current = scopedEntity.id() == null ? Optional.empty() : Optional.ofNullable((ScopedEntity)this.collection.find(MongoUtils.idEq(scopedEntity.id())).first());
        return current.map(this.entityScopeService::isDeletable).orElseGet(() -> this.entityScopeService.isDeletable((ScopedEntity)scopedEntity));
    }

    public final void ensureValidScope(T entity) {
        if (!this.entityScopeService.hasValidScope((ScopedEntity)entity)) {
            throw new IllegalArgumentException("Invalid Entity Scope: " + ((ScopedEntity)entity).scope());
        }
    }

    public final void ensureMutability(T entity) {
        if (!this.isMutable(entity)) {
            throw new IllegalArgumentException("Immutable entity cannot be modified");
        }
    }

    public final void ensureDeletability(T entity) {
        if (!this.isDeletable(entity)) {
            throw new IllegalArgumentException("Non-deletable entity cannot be deleted");
        }
    }
}

