/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indexset.profile;

import com.google.common.primitives.Ints;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import jakarta.inject.Inject;
import jakarta.ws.rs.BadRequestException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoCollections;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedDbService;
import org.graylog2.database.PaginatedList;
import org.graylog2.database.filtering.DbQueryCreator;
import org.graylog2.indexer.indexset.IndexSetService;
import org.graylog2.indexer.indexset.profile.IndexFieldTypeProfile;
import org.graylog2.indexer.indexset.profile.IndexFieldTypeProfileIdAndName;
import org.graylog2.indexer.indexset.profile.IndexFieldTypeProfileUsagesService;
import org.graylog2.indexer.indexset.profile.IndexFieldTypeProfileWithUsages;
import org.graylog2.plugin.Message;
import org.graylog2.rest.models.tools.responses.PageListResponse;
import org.graylog2.rest.resources.entities.EntityAttribute;
import org.graylog2.rest.resources.entities.EntityDefaults;
import org.graylog2.rest.resources.entities.Sorting;
import org.mongojack.WriteResult;

public class IndexFieldTypeProfileService
extends PaginatedDbService<IndexFieldTypeProfile> {
    static final String INDEX_FIELD_TYPE_PROFILE_MONGO_COLLECTION_NAME = "index_field_type_profiles";
    private static final List<EntityAttribute> ATTRIBUTES = List.of(EntityAttribute.builder().id("id").title("Profile Id").hidden(true).sortable(true).build(), EntityAttribute.builder().id("name").title("Profile Name").sortable(true).filterable(true).searchable(true).build(), EntityAttribute.builder().id("description").title("Profile Description").sortable(false).filterable(true).searchable(true).build(), EntityAttribute.builder().id("custom_field_mappings").title("Custom Field Mappings").sortable(false).build());
    private static final EntityDefaults DEFAULTS = EntityDefaults.builder().sort(Sorting.create("name", Sorting.Direction.valueOf("asc".toUpperCase(Locale.ROOT)))).build();
    private final MongoCollection<IndexFieldTypeProfile> profileCollection;
    private final DbQueryCreator dbQueryCreator;
    private final IndexFieldTypeProfileUsagesService indexFieldTypeProfileUsagesService;
    private final IndexSetService indexSetService;

    @Inject
    public IndexFieldTypeProfileService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, MongoCollections mongoCollections, IndexFieldTypeProfileUsagesService indexFieldTypeProfileUsagesService, IndexSetService indexSetService) {
        super(mongoConnection, mapper, IndexFieldTypeProfile.class, INDEX_FIELD_TYPE_PROFILE_MONGO_COLLECTION_NAME);
        this.db.createIndex((DBObject)new BasicDBObject("name", (Object)1), (DBObject)new BasicDBObject("unique", (Object)false));
        this.profileCollection = mongoCollections.collection(INDEX_FIELD_TYPE_PROFILE_MONGO_COLLECTION_NAME, IndexFieldTypeProfile.class);
        this.indexSetService = indexSetService;
        this.dbQueryCreator = new DbQueryCreator("name", ATTRIBUTES);
        this.indexFieldTypeProfileUsagesService = indexFieldTypeProfileUsagesService;
    }

    @Override
    public Optional<IndexFieldTypeProfile> get(String profileId) {
        if (!ObjectId.isValid((String)profileId)) {
            return Optional.empty();
        }
        return super.get(profileId);
    }

    public Optional<IndexFieldTypeProfileWithUsages> getWithUsages(String profileId) {
        if (!ObjectId.isValid((String)profileId)) {
            return Optional.empty();
        }
        Optional<IndexFieldTypeProfile> indexFieldTypeProfile = this.get(profileId);
        return indexFieldTypeProfile.map(profile -> new IndexFieldTypeProfileWithUsages((IndexFieldTypeProfile)profile, this.indexFieldTypeProfileUsagesService.usagesOfProfile(profile.id())));
    }

    @Override
    public IndexFieldTypeProfile save(IndexFieldTypeProfile indexFieldTypeProfile) {
        indexFieldTypeProfile.customFieldMappings().forEach(mapping -> this.checkFieldTypeCanBeChanged(mapping.fieldName()));
        return super.save(indexFieldTypeProfile);
    }

    @Override
    public int delete(String id) {
        if (!ObjectId.isValid((String)id)) {
            return 0;
        }
        int numRemoved = super.delete(id);
        this.indexSetService.removeReferencesToProfile(id);
        return numRemoved;
    }

    public boolean update(String profileId, IndexFieldTypeProfile updatedProfile) {
        if (!ObjectId.isValid((String)profileId)) {
            return false;
        }
        updatedProfile.customFieldMappings().forEach(mapping -> this.checkFieldTypeCanBeChanged(mapping.fieldName()));
        WriteResult<IndexFieldTypeProfile, ObjectId> writeResult = this.db.updateById(new ObjectId(profileId), updatedProfile);
        return writeResult.getN() > 0;
    }

    public PageListResponse<IndexFieldTypeProfileWithUsages> getPaginated(String query, List<String> filters, int page, int perPage, String sortField, String order) {
        Bson dbQuery = this.dbQueryCreator.createDbQuery(filters, query);
        Bson dbSort = "desc".equalsIgnoreCase(order) ? Sorts.descending((String[])new String[]{sortField}) : Sorts.ascending((String[])new String[]{sortField});
        long total = this.profileCollection.countDocuments(dbQuery);
        ArrayList singlePageOfProfiles = new ArrayList(perPage);
        this.profileCollection.find(dbQuery).sort(dbSort).limit(perPage).skip(perPage * Math.max(0, page - 1)).into(singlePageOfProfiles);
        Map<String, Set<String>> profileUsagesInIndexSets = this.indexFieldTypeProfileUsagesService.usagesOfProfiles(singlePageOfProfiles.stream().map(IndexFieldTypeProfile::id).collect(Collectors.toSet()));
        PaginatedList paginated = new PaginatedList(singlePageOfProfiles.stream().map(profile -> new IndexFieldTypeProfileWithUsages((IndexFieldTypeProfile)profile, (Set)profileUsagesInIndexSets.get(profile.id()))).collect(Collectors.toList()), Ints.saturatedCast((long)total), page, perPage);
        return PageListResponse.create(query, paginated, sortField, order, ATTRIBUTES, DEFAULTS);
    }

    @Deprecated
    public List<IndexFieldTypeProfileIdAndName> getAll() {
        return (List)this.profileCollection.find().projection(Projections.include((String[])new String[]{"id", "name"})).sort(Sorts.ascending((String[])new String[]{"name"})).map(profile -> new IndexFieldTypeProfileIdAndName(profile.id(), profile.name())).into(new LinkedList());
    }

    private void checkFieldTypeCanBeChanged(String fieldName) {
        if (Message.FIELDS_UNCHANGEABLE_BY_CUSTOM_MAPPINGS.contains((Object)fieldName)) {
            throw new BadRequestException("Unable to change field type of " + fieldName + ", not allowed to change type of these fields: " + Message.FIELDS_UNCHANGEABLE_BY_CUSTOM_MAPPINGS);
        }
    }
}

