/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indexset.profile;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoConnection;

public class IndexFieldTypeProfileUsagesService {
    public static final String INDEX_SET_ID = "_id";
    private final MongoCollection<Document> indexSetsCollection;

    @Inject
    public IndexFieldTypeProfileUsagesService(MongoConnection mongoConnection) {
        this.indexSetsCollection = mongoConnection.getMongoDatabase().getCollection("index_sets");
    }

    public Set<String> usagesOfProfile(String profileId) {
        if (!ObjectId.isValid((String)profileId)) {
            return Set.of();
        }
        HashSet<String> usagesInIndexSet = new HashSet<String>();
        this.indexSetsCollection.find(Filters.eq((String)"field_type_profile", (Object)profileId)).projection(Projections.include((String[])new String[]{INDEX_SET_ID})).map(document -> document.getObjectId((Object)INDEX_SET_ID).toString()).into(usagesInIndexSet);
        return usagesInIndexSet;
    }

    public Map<String, Set<String>> usagesOfProfiles(Set<String> profilesIds) {
        HashMap<String, Set<String>> usagesInIndexSet = new HashMap<String, Set<String>>();
        profilesIds.forEach(profId -> usagesInIndexSet.put((String)profId, new HashSet()));
        this.indexSetsCollection.find(Filters.in((String)"field_type_profile", profilesIds.stream().filter(ObjectId::isValid).toList())).projection(Projections.include((String[])new String[]{INDEX_SET_ID, "field_type_profile"})).forEach(document -> {
            String indexSetId = document.getObjectId((Object)INDEX_SET_ID).toString();
            String profileId = document.getString((Object)"field_type_profile");
            ((Set)usagesInIndexSet.get(profileId)).add(indexSetId);
        });
        return usagesInIndexSet;
    }
}

