/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.migration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.math.RoundingMode;

public record IndexMigrationProgress(long total, long created, long updated, long deleted, long versionConflicts, long noops) {
    private static final BigDecimal ONE_HUNDRED_PERCENT = new BigDecimal(100);

    public int progressPercent() {
        return this.progress().scaleByPowerOfTen(2).intValue();
    }

    @JsonIgnore
    public BigDecimal progress() {
        if (this.total == 0L) {
            return BigDecimal.ONE;
        }
        BigDecimal value = BigDecimal.valueOf(this.created + this.updated + this.deleted + this.versionConflicts + this.noops);
        return value.divide(BigDecimal.valueOf(this.total), 4, RoundingMode.HALF_UP);
    }
}

