/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.migration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.jsonwebtoken.lang.Collections;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.graylog2.indexer.datanode.RemoteReindexingMigrationAdapter;
import org.graylog2.indexer.migration.LogEntry;
import org.graylog2.indexer.migration.RemoteReindexIndex;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RemoteReindexMigration {
    @JsonProperty(value="id")
    private final String id;
    private final List<RemoteReindexIndex> indices;
    private final List<LogEntry> logs;
    @JsonProperty(value="error")
    private String error;

    @JsonCreator
    public RemoteReindexMigration(@JsonProperty(value="id") @NotNull String migrationID, @JsonProperty(value="indices") List<RemoteReindexIndex> indices, @JsonProperty(value="logs") List<LogEntry> logs) {
        this.id = migrationID;
        this.indices = indices;
        this.logs = logs;
    }

    public static RemoteReindexMigration nonExistent(String migrationID) {
        return new RemoteReindexMigration(migrationID, Collections.emptyList(), Collections.emptyList());
    }

    @JsonProperty(value="indices")
    public List<RemoteReindexIndex> indices() {
        return this.indices;
    }

    public String id() {
        return this.id;
    }

    @JsonProperty(value="status")
    public RemoteReindexingMigrationAdapter.Status status() {
        if (this.indices.isEmpty() || this.indices.stream().allMatch(i -> i.status() == RemoteReindexingMigrationAdapter.Status.NOT_STARTED)) {
            return RemoteReindexingMigrationAdapter.Status.NOT_STARTED;
        }
        if (this.indices.stream().allMatch(RemoteReindexIndex::isCompleted)) {
            if (this.indices.stream().anyMatch(i -> i.status() == RemoteReindexingMigrationAdapter.Status.ERROR)) {
                return RemoteReindexingMigrationAdapter.Status.ERROR;
            }
            return RemoteReindexingMigrationAdapter.Status.FINISHED;
        }
        return RemoteReindexingMigrationAdapter.Status.RUNNING;
    }

    @JsonProperty(value="progress")
    public int progress() {
        if (this.indices.isEmpty()) {
            return 100;
        }
        BigDecimal sum = this.indices.stream().filter(i -> i.progress() != null).map(RemoteReindexMigration::indexProgress).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sum.divide(BigDecimal.valueOf(this.indices.size()), 4, RoundingMode.HALF_UP).scaleByPowerOfTen(2).intValue();
    }

    private static BigDecimal indexProgress(RemoteReindexIndex i) {
        if (i.isCompleted()) {
            return BigDecimal.ONE;
        }
        return i.progress().progress();
    }

    public List<LogEntry> getLogs() {
        return Optional.ofNullable(this.logs).map(l -> l.stream().toList()).orElse(Collections.emptyList());
    }

    @JsonProperty(value="tasks_progress")
    public Map<String, Integer> getTasksProgress() {
        return this.indices.stream().filter(i -> i.status() == RemoteReindexingMigrationAdapter.Status.RUNNING).filter(i -> i.progress() != null).sorted(Comparator.comparing(RemoteReindexIndex::name)).collect(Collectors.toMap(RemoteReindexIndex::name, i -> i.progress().progressPercent(), (integer, integer2) -> integer, LinkedHashMap::new));
    }
}

