/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.retention;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.retention.strategies.ClosingRetentionStrategy;
import org.graylog2.indexer.retention.strategies.DeletionRetentionStrategy;
import org.graylog2.indexer.retention.strategies.NoopRetentionStrategy;
import org.graylog2.plugin.PluginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetentionStrategyBindings
extends PluginModule {
    private static final Logger LOG = LoggerFactory.getLogger(RetentionStrategyBindings.class);
    private final ElasticsearchConfiguration configuration;

    public RetentionStrategyBindings(ElasticsearchConfiguration elasticsearchConfiguration) {
        this.configuration = elasticsearchConfiguration;
    }

    protected void configure() {
        LinkedList<Class> retentionStrategies = new LinkedList<Class>(Arrays.asList(DeletionRetentionStrategy.class, ClosingRetentionStrategy.class, NoopRetentionStrategy.class));
        Set<String> disabledRetentionStrategies = this.configuration.getDisabledRetentionStrategies();
        Iterator<String> iterator = disabledRetentionStrategies.iterator();
        block10: while (iterator.hasNext()) {
            String disabledStrategy;
            switch (disabledStrategy = iterator.next()) {
                case "delete": {
                    retentionStrategies.remove(DeletionRetentionStrategy.class);
                    continue block10;
                }
                case "close": {
                    retentionStrategies.remove(ClosingRetentionStrategy.class);
                    continue block10;
                }
                case "none": {
                    retentionStrategies.remove(NoopRetentionStrategy.class);
                    continue block10;
                }
            }
            LOG.debug("Detected graylog open unknown retention strategy: {}", (Object)disabledStrategy);
        }
        for (Class adding : retentionStrategies) {
            this.addRetentionStrategy(adding);
        }
    }
}

