/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup.db;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoCollections;
import org.graylog2.database.PaginatedList;
import org.graylog2.database.entities.EntityScopeService;
import org.graylog2.database.pagination.MongoPaginationHelper;
import org.graylog2.database.utils.MongoUtils;
import org.graylog2.database.utils.ScopedEntityMongoUtils;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.lookup.dto.CacheDto;
import org.graylog2.lookup.events.CachesDeleted;
import org.graylog2.lookup.events.CachesUpdated;

public class DBCacheService {
    public static final String COLLECTION_NAME = "lut_caches";
    private final ClusterEventBus clusterEventBus;
    private final MongoCollection<CacheDto> collection;
    private final MongoUtils<CacheDto> mongoUtils;
    private final ScopedEntityMongoUtils<CacheDto> scopedEntityMongoUtils;
    private final MongoPaginationHelper<CacheDto> paginationHelper;

    @Inject
    public DBCacheService(MongoCollections mongoCollections, EntityScopeService entityScopeService, ClusterEventBus clusterEventBus) {
        this.clusterEventBus = clusterEventBus;
        this.collection = mongoCollections.collection(COLLECTION_NAME, CacheDto.class);
        this.mongoUtils = mongoCollections.utils(this.collection);
        this.scopedEntityMongoUtils = mongoCollections.scopedEntityUtils(this.collection, entityScopeService);
        this.paginationHelper = mongoCollections.paginationHelper(this.collection);
        this.collection.createIndex(Indexes.ascending((String[])new String[]{"name"}), new IndexOptions().unique(true));
    }

    public Optional<CacheDto> get(String idOrName) {
        if (ObjectId.isValid((String)idOrName)) {
            return this.mongoUtils.getById(idOrName);
        }
        return Optional.ofNullable((CacheDto)this.collection.find(Filters.eq((String)"name", (Object)idOrName)).first());
    }

    public CacheDto save(CacheDto cache) {
        CacheDto savedCache;
        if (cache.id() == null) {
            String id = this.scopedEntityMongoUtils.create(cache);
            savedCache = ((CacheDto.Builder)cache.toBuilder().id(id)).build();
        } else {
            savedCache = this.scopedEntityMongoUtils.update(cache);
        }
        return savedCache;
    }

    public CacheDto saveAndPostEvent(CacheDto cache) {
        CacheDto savedCache = this.save(cache);
        this.clusterEventBus.post(CachesUpdated.create(savedCache.id()));
        return savedCache;
    }

    public void postBulkUpdate(Set<String> updatedCacheIds) {
        this.clusterEventBus.post(CachesUpdated.create(updatedCacheIds));
    }

    public PaginatedList<CacheDto> findPaginated(Bson query, Bson sort, int page, int perPage) {
        return this.paginationHelper.filter(query).sort(sort).perPage(perPage).page(page);
    }

    public void deleteAndPostEvent(String idOrName) {
        Optional<CacheDto> cacheDto = this.get(idOrName);
        cacheDto.ifPresent(cache -> {
            this.scopedEntityMongoUtils.deleteById(cache.id());
            this.clusterEventBus.post(CachesDeleted.create(cache.id()));
        });
    }

    public void deleteAndPostEventImmutable(String idOrName) {
        Optional<CacheDto> cacheDto = this.get(idOrName);
        cacheDto.ifPresent(cache -> {
            this.scopedEntityMongoUtils.forceDelete(cache.id());
            this.clusterEventBus.post(CachesDeleted.create(cache.id()));
        });
    }

    public Collection<CacheDto> findByIds(Set<String> idSet) {
        return MongoUtils.stream(this.collection.find(MongoUtils.stringIdsIn(idSet))).toList();
    }

    public Collection<CacheDto> findAll() {
        return MongoUtils.stream(this.collection.find()).toList();
    }
}

