/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.graylog2.configuration.IndexSetDefaultTemplateConfigFactory;
import org.graylog2.configuration.IndexSetsDefaultConfiguration;
import org.graylog2.datatiering.DataTieringConfig;
import org.graylog2.datatiering.fallback.PlaceholderDataTieringConfig;
import org.graylog2.indexer.indexset.template.IndexSetDefaultTemplateService;
import org.graylog2.indexer.indexset.template.IndexSetTemplate;
import org.graylog2.indexer.indexset.template.IndexSetTemplateConfig;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V202211021200_CreateDefaultIndexTemplate
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V202211021200_CreateDefaultIndexTemplate.class);
    public static final String TEMPLATE_DESCRIPTION = "A generated template used for index sets that are created automatically, such as by Illuminate packs.";
    private final ClusterConfigService clusterConfigService;
    private final IndexSetDefaultTemplateConfigFactory factory;
    private final IndexSetDefaultTemplateService indexSetDefaultTemplateService;

    @Inject
    public V202211021200_CreateDefaultIndexTemplate(ClusterConfigService clusterConfigService, IndexSetDefaultTemplateConfigFactory factory, IndexSetDefaultTemplateService indexSetDefaultTemplateService) {
        this.clusterConfigService = clusterConfigService;
        this.factory = factory;
        this.indexSetDefaultTemplateService = indexSetDefaultTemplateService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2022-11-02T12:00:00Z");
    }

    @Override
    public void upgrade() {
        Optional<IndexSetTemplate> defaultIndexSetTemplate = this.indexSetDefaultTemplateService.getDefaultIndexSetTemplate();
        if (defaultIndexSetTemplate.isEmpty()) {
            IndexSetsDefaultConfiguration legacyDefaultConfig = this.clusterConfigService.get(IndexSetsDefaultConfiguration.class);
            if (legacyDefaultConfig == null) {
                this.saveDefaultTemplate(this.factory.create());
            } else {
                this.saveDefaultTemplate(this.createTemplateConfig(legacyDefaultConfig));
                this.removeLegacyConfig();
            }
        } else {
            LOG.debug("Migration already completed.");
        }
    }

    private IndexSetTemplateConfig createTemplateConfig(IndexSetsDefaultConfiguration legacyDefaultConfig) {
        DataTieringConfig dataTieringConfig = legacyDefaultConfig.dataTiering();
        if (legacyDefaultConfig.dataTiering() instanceof PlaceholderDataTieringConfig) {
            dataTieringConfig = this.factory.getDataTieringConfig(legacyDefaultConfig.rotationStrategyConfig());
        }
        return IndexSetTemplateConfig.builder().indexAnalyzer(legacyDefaultConfig.indexAnalyzer()).shards(legacyDefaultConfig.shards()).replicas(legacyDefaultConfig.replicas()).indexOptimizationMaxNumSegments(legacyDefaultConfig.indexOptimizationMaxNumSegments()).indexOptimizationDisabled(legacyDefaultConfig.indexOptimizationDisabled()).fieldTypeRefreshInterval(Duration.standardSeconds((long)legacyDefaultConfig.fieldTypeRefreshIntervalUnit().toSeconds(legacyDefaultConfig.fieldTypeRefreshInterval()))).rotationStrategyClass(legacyDefaultConfig.rotationStrategyClass()).rotationStrategyConfig(legacyDefaultConfig.rotationStrategyConfig()).retentionStrategyClass(legacyDefaultConfig.retentionStrategyClass()).retentionStrategyConfig(legacyDefaultConfig.retentionStrategyConfig()).dataTieringConfig(dataTieringConfig).useLegacyRotation(legacyDefaultConfig.useLegacyRotation()).build();
    }

    private void saveDefaultTemplate(IndexSetTemplateConfig indexSetTemplateConfig) {
        IndexSetTemplate defaultIndexSetTemplate = new IndexSetTemplate(null, "Default Template", TEMPLATE_DESCRIPTION, false, indexSetTemplateConfig);
        try {
            this.indexSetDefaultTemplateService.createAndSaveDefault(defaultIndexSetTemplate);
            LOG.debug("IndexSetDefaultTemplate saved.");
        }
        catch (Exception e) {
            LOG.error("Unable to write IndexSetDefaultTemplate.", (Throwable)e);
        }
    }

    private void removeLegacyConfig() {
        try {
            this.clusterConfigService.remove(IndexSetsDefaultConfiguration.class);
        }
        catch (Exception e) {
            LOG.debug("Unable to remove legacy IndexSetsDefaultConfiguration configuration.", (Throwable)e);
        }
    }
}

