/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.models;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import org.graylog2.database.PaginatedList;

@JsonAutoDetect
public class PaginatedResponse<T> {
    private final String listKey;
    private final PaginatedList<T> paginatedList;
    private final String query;
    private final Map<String, Object> context;

    private PaginatedResponse(String listKey, PaginatedList<T> paginatedList, @Nullable String query, @Nullable Map<String, Object> context) {
        this.listKey = listKey;
        this.paginatedList = paginatedList;
        this.query = query;
        this.context = context;
    }

    @JsonValue
    public Map<String, Object> jsonValue() {
        ImmutableMap.Builder builder = ImmutableMap.builder().putAll(this.paginatedList.pagination().asMap()).put((Object)this.listKey, new ArrayList<T>(this.paginatedList));
        if (this.query != null) {
            builder.put((Object)"query", (Object)this.query);
        }
        if (this.paginatedList.grandTotal().isPresent()) {
            builder.put((Object)"grand_total", (Object)this.paginatedList.grandTotal().get());
        }
        if (this.context != null && !this.context.isEmpty()) {
            builder.put((Object)"context", this.context);
        }
        return builder.build();
    }

    public static <T> PaginatedResponse<T> create(String listKey, PaginatedList<T> paginatedList) {
        return new PaginatedResponse<T>(listKey, paginatedList, null, null);
    }

    public static <T> PaginatedResponse<T> create(String listKey, PaginatedList<T> paginatedList, Map<String, Object> context) {
        return new PaginatedResponse<T>(listKey, paginatedList, null, context);
    }

    public static <T> PaginatedResponse<T> create(String listKey, PaginatedList<T> paginatedList, String query) {
        return new PaginatedResponse<T>(listKey, paginatedList, query, null);
    }

    public static <T> PaginatedResponse<T> create(String listKey, PaginatedList<T> paginatedList, String query, Map<String, Object> context) {
        return new PaginatedResponse<T>(listKey, paginatedList, query, context);
    }

    public PaginatedList<T> paginatedList() {
        return this.paginatedList;
    }
}

