/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.cluster;

import com.codahale.metrics.annotation.Timed;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.rest.resources.system.RemoteSystemShutdownResource;
import org.graylog2.shared.rest.resources.ProxiedResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

@RequiresAuthentication
@Path(value="/cluster/{nodeId}/shutdown")
@Produces(value={"application/json"})
@Deprecated
public class ClusterSystemShutdownResource
extends ProxiedResource {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterSystemShutdownResource.class);

    @Inject
    public ClusterSystemShutdownResource(NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider, @Context HttpHeaders httpHeaders, @Named(value="proxiedRequestsExecutorService") ExecutorService executorService) throws NodeNotFoundException {
        super(httpHeaders, nodeService, remoteInterfaceProvider, executorService);
    }

    @POST
    @Timed
    @AuditEvent(type="server:node_shutdown:initiate")
    public void shutdown(@PathParam(value="nodeId") String nodeId) throws IOException, NodeNotFoundException {
        LOG.warn("Deprecated API endpoint /cluster/{nodeId}/shutdown was called. Shutting down nodes via the API is discouraged in favor of using a service manager to control the server process.");
        Node targetNode = this.nodeService.byNodeId(nodeId);
        RemoteSystemShutdownResource remoteSystemShutdownResource = this.remoteInterfaceProvider.get(targetNode, this.getAuthenticationToken(), RemoteSystemShutdownResource.class);
        Response response = remoteSystemShutdownResource.shutdown().execute();
        if (response.code() != Response.Status.ACCEPTED.getStatusCode()) {
            LOG.warn("Unable send shut down signal to node {}: {}", (Object)nodeId, (Object)response.message());
            throw new WebApplicationException(response.message(), Response.Status.BAD_GATEWAY);
        }
    }
}

