/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.messageq;

import java.util.List;
import org.graylog2.shared.messageq.Acknowledgeable;
import org.graylog2.shared.messageq.MessageQueueAcknowledger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageQueueAcknowledger<T>
implements MessageQueueAcknowledger {
    private static final Logger log = LoggerFactory.getLogger(AbstractMessageQueueAcknowledger.class);
    protected final Class<T> queueIdClass;
    protected final MessageQueueAcknowledger.Metrics metrics;

    public AbstractMessageQueueAcknowledger(Class<T> queueIdClass, MessageQueueAcknowledger.Metrics metrics) {
        this.queueIdClass = queueIdClass;
        this.metrics = metrics;
    }

    @Override
    public void acknowledge(Object queueId) {
        if (this.isValidMessageQueueId(queueId)) {
            this.doAcknowledge(queueId);
            this.metrics.acknowledgedMessages().mark();
        }
    }

    @Override
    public void acknowledge(Acknowledgeable message) {
        this.acknowledge(message.getMessageQueueId());
    }

    @Override
    public void acknowledge(List<? extends Acknowledgeable> messages) {
        messages.forEach(message -> this.acknowledge(message.getMessageQueueId()));
    }

    protected abstract void doAcknowledge(T var1);

    protected boolean isValidMessageQueueId(Object object) {
        if (this.queueIdClass.isInstance(object)) {
            return true;
        }
        if (object != null) {
            log.error("{} is unable to acknowledge message. Expected <{}> to be of type <{}>, but found <{}>.", new Object[]{this.getClass().getSimpleName(), object, this.queueIdClass.getSimpleName(), object.getClass().getSimpleName()});
        }
        return false;
    }
}

