/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.resources.system.codecs;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.inputs.codecs.CodecFactory;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.graylog2.rest.models.system.codecs.responses.CodecTypeInfo;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="System/Codecs/Types", description="Message codec types of this node")
@Path(value="/system/codecs/types")
@Produces(value={"application/json"})
public class CodecTypesResource
extends RestResource {
    private CodecFactory codecFactory;

    @Inject
    public CodecTypesResource(CodecFactory codecFactory) {
        this.codecFactory = codecFactory;
    }

    @GET
    @Timed
    @Path(value="/all")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Get all codec types")
    public Map<String, CodecTypeInfo> getAll() {
        Map<String, Codec.Factory<? extends Codec>> factories = this.codecFactory.getFactory();
        return factories.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            Codec.Factory factory = (Codec.Factory)entry.getValue();
            return CodecTypeInfo.fromConfigurationRequest((String)entry.getKey(), factory.getDescriptor().getName(), factory.getConfig().getRequestedConfiguration());
        }));
    }
}

