/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.telemetry.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.OkHttpClient;
import org.graylog2.configuration.TelemetryConfiguration;
import org.graylog2.telemetry.client.PosthogAPI;
import org.graylog2.telemetry.cluster.TelemetryClusterService;
import org.graylog2.telemetry.scheduler.TelemetryEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

@Singleton
public class TelemetryClient {
    private static final Logger LOG = LoggerFactory.getLogger(TelemetryClient.class);
    private final PosthogAPI posthog;
    private final String clusterId;
    private final boolean isEnabled;
    private final String apiKey;

    @Inject
    public TelemetryClient(TelemetryConfiguration telemetryConfiguration, TelemetryClusterService telemetryClusterService, OkHttpClient okHttpClient, ObjectMapper objectMapper) {
        this.isEnabled = telemetryConfiguration.isTelemetryEnabled();
        this.apiKey = telemetryConfiguration.getTelemetryApiKey();
        this.posthog = (PosthogAPI)new Retrofit.Builder().baseUrl(telemetryConfiguration.getTelemetryApiHost()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)objectMapper)).client(okHttpClient).build().create(PosthogAPI.class);
        this.clusterId = telemetryClusterService.getClusterId();
    }

    public void capture(Map<String, TelemetryEvent> events) throws IOException {
        List<PosthogAPI.Event> batch;
        PosthogAPI.BatchRequest request;
        Response response;
        if (this.isEnabled && !(response = this.posthog.batchSend(request = new PosthogAPI.BatchRequest(this.apiKey, batch = events.entrySet().stream().map(entry -> PosthogAPI.Event.create(this.clusterId, (String)entry.getKey(), ((TelemetryEvent)entry.getValue()).metrics())).toList())).execute()).isSuccessful()) {
            throw new RuntimeException("Submitting telemetry failed with status " + response.code() + " - message: " + response.message());
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }
}

