/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.telemetry.scheduler;

import com.github.joschi.jadconfig.util.Duration;
import jakarta.inject.Inject;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.graylog2.configuration.TelemetryConfiguration;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.telemetry.client.TelemetryClient;
import org.graylog2.telemetry.scheduler.TelemetryEvent;
import org.graylog2.telemetry.scheduler.TelemetryMetricSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelemetrySubmissionPeriodical
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(TelemetrySubmissionPeriodical.class);
    private final TelemetryClient telemetryClient;
    private final Map<String, TelemetryMetricSupplier> metricsProviders;
    private static final Duration runPeriod = Duration.days((long)1L);
    private final boolean isEnabled;

    @Inject
    public TelemetrySubmissionPeriodical(TelemetryClient telemetryClient, TelemetryConfiguration telemetryConfiguration, Map<String, TelemetryMetricSupplier> metricsProviders) {
        this.telemetryClient = telemetryClient;
        this.metricsProviders = metricsProviders;
        this.isEnabled = telemetryConfiguration.isTelemetryEnabled();
    }

    @Override
    public void doRun() {
        Map<String, TelemetryEvent> telemetryMetrics = this.metricsProviders.entrySet().stream().map(entry -> this.entry((String)entry.getKey(), (Optional)((TelemetryMetricSupplier)entry.getValue()).get())).flatMap(entry -> ((Optional)entry.getValue()).map(metrics -> this.entry((String)entry.getKey(), metrics)).stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        try {
            if (!telemetryMetrics.isEmpty()) {
                this.telemetryClient.capture(telemetryMetrics);
            }
        }
        catch (Exception e) {
            LOG.warn("Error while submitting telemetry: ", (Throwable)e);
        }
    }

    private <K, V> Map.Entry<K, V> entry(K key, V value) {
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return this.isEnabled;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return Math.toIntExact(runPeriod.toSeconds());
    }

    @Override
    public int getPeriodSeconds() {
        return Math.toIntExact(runPeriod.toSeconds());
    }

    @Override
    @Nonnull
    protected Logger getLogger() {
        return LOG;
    }
}

