/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.fields;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.graylog.events.fields.EventFieldSpec;
import org.graylog.events.fields.FieldValueType;
import org.graylog.events.fields.providers.FieldValueProvider;

final class AutoValue_EventFieldSpec
extends EventFieldSpec {
    private final FieldValueType dataType;
    private final List<FieldValueProvider.Config> providers;

    private AutoValue_EventFieldSpec(FieldValueType dataType, List<FieldValueProvider.Config> providers) {
        this.dataType = dataType;
        this.providers = providers;
    }

    @Override
    @JsonProperty(value="data_type")
    public FieldValueType dataType() {
        return this.dataType;
    }

    @Override
    @JsonProperty(value="providers")
    public List<FieldValueProvider.Config> providers() {
        return this.providers;
    }

    public String toString() {
        return "EventFieldSpec{dataType=" + this.dataType + ", providers=" + this.providers + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EventFieldSpec) {
            EventFieldSpec that = (EventFieldSpec)o;
            return this.dataType.equals(that.dataType()) && this.providers.equals(that.providers());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.dataType.hashCode();
        h$ *= 1000003;
        return h$ ^= this.providers.hashCode();
    }

    @Override
    public EventFieldSpec.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends EventFieldSpec.Builder {
        private FieldValueType dataType;
        private List<FieldValueProvider.Config> providers;

        Builder() {
        }

        Builder(EventFieldSpec source) {
            this.dataType = source.dataType();
            this.providers = source.providers();
        }

        @Override
        public EventFieldSpec.Builder dataType(FieldValueType dataType) {
            if (dataType == null) {
                throw new NullPointerException("Null dataType");
            }
            this.dataType = dataType;
            return this;
        }

        @Override
        public EventFieldSpec.Builder providers(List<FieldValueProvider.Config> providers) {
            if (providers == null) {
                throw new NullPointerException("Null providers");
            }
            this.providers = providers;
            return this;
        }

        @Override
        public EventFieldSpec build() {
            if (this.dataType == null || this.providers == null) {
                StringBuilder missing = new StringBuilder();
                if (this.dataType == null) {
                    missing.append(" dataType");
                }
                if (this.providers == null) {
                    missing.append(" providers");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_EventFieldSpec(this.dataType, this.providers);
        }
    }
}

