/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.notifications.types;

import com.google.common.base.Strings;
import com.unboundid.util.Base64;
import java.nio.charset.StandardCharsets;
import okhttp3.HttpUrl;
import okhttp3.Request;
import org.graylog.events.notifications.TemporaryEventNotificationException;
import org.graylog2.security.encryption.EncryptedValue;
import org.graylog2.security.encryption.EncryptedValueService;
import org.graylog2.system.urlwhitelist.UrlWhitelistNotificationService;
import org.graylog2.system.urlwhitelist.UrlWhitelistService;

public class HTTPNotification {
    private final UrlWhitelistService whitelistService;
    private final UrlWhitelistNotificationService urlWhitelistNotificationService;
    private final EncryptedValueService encryptedValueService;

    public HTTPNotification(UrlWhitelistService whitelistService, UrlWhitelistNotificationService urlWhitelistNotificationService, EncryptedValueService encryptedValueService) {
        this.whitelistService = whitelistService;
        this.urlWhitelistNotificationService = urlWhitelistNotificationService;
        this.encryptedValueService = encryptedValueService;
    }

    public HttpUrl validateUrl(String url, String notificationId, String eventDefTitle) throws TemporaryEventNotificationException {
        HttpUrl httpUrl = HttpUrl.parse((String)url);
        if (httpUrl == null) {
            throw new TemporaryEventNotificationException("Malformed URL: <" + url + "> in notification <" + notificationId + ">");
        }
        if (!this.whitelistService.isWhitelisted(url)) {
            if (!"NotificationTestId".equals(notificationId)) {
                this.publishSystemNotificationForWhitelistFailure(url, eventDefTitle);
            }
            throw new TemporaryEventNotificationException("URL <" + url + "> is not whitelisted.");
        }
        return httpUrl;
    }

    public void addAuthHeader(Request.Builder builder, EncryptedValue auth) {
        String basicAuthHeaderValue = this.getBasicAuthHeaderValue(auth);
        if (!Strings.isNullOrEmpty((String)basicAuthHeaderValue)) {
            builder.addHeader("Authorization", basicAuthHeaderValue);
        }
    }

    public void addApiKey(Request.Builder builder, HttpUrl httpUrl, String apiKey, EncryptedValue apiSecret, boolean sendAsHeader) {
        if (!Strings.isNullOrEmpty((String)apiKey)) {
            String apiKeyValue = this.getApiKeyValue(apiSecret);
            if (sendAsHeader) {
                builder.url(httpUrl);
                builder.addHeader(apiKey, apiKeyValue);
            } else {
                builder.url(httpUrl.newBuilder().addQueryParameter(apiKey, apiKeyValue).build());
            }
        } else {
            builder.url(httpUrl);
        }
    }

    public void addHeaders(Request.Builder builder, String headerString) {
        if (!Strings.isNullOrEmpty((String)headerString)) {
            for (String nameVal : headerString.split(";")) {
                String[] nameValArr = nameVal.split(":", 2);
                String name = nameValArr[0].trim();
                String val = nameValArr[1].trim();
                builder.addHeader(name, val);
            }
        }
    }

    private String getBasicAuthHeaderValue(EncryptedValue auth) {
        EncryptedValue basicAuth = auth == null ? EncryptedValue.createUnset() : auth;
        String credentials = this.encryptedValueService.decrypt(basicAuth);
        return credentials == null ? null : "Basic " + Base64.encode((byte[])credentials.getBytes(StandardCharsets.UTF_8));
    }

    private String getApiKeyValue(EncryptedValue apiSecret) {
        if (apiSecret == null || !apiSecret.isSet()) {
            return null;
        }
        return this.encryptedValueService.decrypt(apiSecret);
    }

    private void publishSystemNotificationForWhitelistFailure(String url, String eventNotificationTitle) {
        String description = "The alert notification \"" + eventNotificationTitle + "\" is trying to access a URL which is not whitelisted. Please check your configuration. [url: \"" + url + "\"]";
        this.urlWhitelistNotificationService.publishWhitelistFailure(description);
    }
}

