/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.grn.providers;

import jakarta.inject.Inject;
import org.graylog.grn.GRN;
import org.graylog.grn.GRNDescriptor;
import org.graylog.grn.GRNDescriptorProvider;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.streams.StreamService;

public class StreamGRNDescriptorProvider
implements GRNDescriptorProvider {
    private final StreamService streamService;

    @Inject
    public StreamGRNDescriptorProvider(StreamService streamService) {
        this.streamService = streamService;
    }

    @Override
    public GRNDescriptor get(GRN grn) {
        try {
            Stream stream = this.streamService.load(grn.entity());
            return GRNDescriptor.create(grn, stream.getTitle());
        }
        catch (NotFoundException e) {
            return GRNDescriptor.create(grn, "ERROR: Stream for <" + grn.toString() + "> not found!");
        }
    }
}

