/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.pagerduty;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.net.URI;
import java.net.URISyntaxException;
import org.graylog.events.contentpack.entities.EventNotificationConfigEntity;
import org.graylog.events.event.EventDto;
import org.graylog.events.notifications.EventNotificationConfig;
import org.graylog.events.notifications.EventNotificationExecutionJob;
import org.graylog.integrations.pagerduty.AutoValue_PagerDutyNotificationConfig;
import org.graylog.integrations.pagerduty.PagerDutyNotificationConfigEntity;
import org.graylog.scheduler.JobTriggerData;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.plugin.rest.ValidationResult;

@JsonTypeName(value="pagerduty-notification-v2")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class PagerDutyNotificationConfig
implements EventNotificationConfig {
    public static final String TYPE_NAME = "pagerduty-notification-v2";
    static final String FIELD_ROUTING_KEY = "routing_key";
    static final String FIELD_CUSTOM_INCIDENT = "custom_incident";
    static final String FIELD_KEY_PREFIX = "key_prefix";
    static final String FIELD_CLIENT_NAME = "client_name";
    static final String FIELD_CLIENT_URL = "client_url";

    @JsonProperty(value="routing_key")
    public abstract String routingKey();

    @JsonProperty(value="custom_incident")
    public abstract boolean customIncident();

    @JsonProperty(value="key_prefix")
    public abstract String keyPrefix();

    @JsonProperty(value="client_name")
    public abstract String clientName();

    @JsonProperty(value="client_url")
    public abstract String clientUrl();

    @Override
    @JsonIgnore
    public JobTriggerData toJobTriggerData(EventDto dto) {
        return EventNotificationExecutionJob.Data.builder().eventDto(dto).build();
    }

    public static Builder builder() {
        return Builder.create();
    }

    @Override
    @JsonIgnore
    public ValidationResult validate() {
        ValidationResult validation = new ValidationResult();
        if (this.routingKey().isEmpty()) {
            validation.addError(FIELD_ROUTING_KEY, "Routing Key cannot be empty.");
        } else if (this.routingKey().length() != 32) {
            validation.addError(FIELD_ROUTING_KEY, "Routing Key must be 32 characters long.");
        }
        if (this.customIncident() && this.keyPrefix().isEmpty()) {
            validation.addError(FIELD_KEY_PREFIX, "Incident Key Prefix cannot be empty when Custom Incident Key is selected.");
        }
        if (this.clientName().isEmpty()) {
            validation.addError(FIELD_CLIENT_NAME, "Client Name cannot be empty.");
        }
        if (this.clientUrl().isEmpty()) {
            validation.addError(FIELD_CLIENT_URL, "Client URL cannot be empty.");
        } else {
            try {
                URI clientUri = new URI(this.clientUrl());
                if (!"http".equals(clientUri.getScheme()) && !"https".equals(clientUri.getScheme())) {
                    validation.addError(FIELD_CLIENT_URL, "Client URL must be a valid HTTP or HTTPS URL.");
                }
            }
            catch (URISyntaxException e) {
                validation.addError(FIELD_CLIENT_URL, "Couldn't parse Client URL correctly.");
            }
        }
        return validation;
    }

    @Override
    public EventNotificationConfigEntity toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
        return PagerDutyNotificationConfigEntity.builder().routingKey(ValueReference.of(this.routingKey())).customIncident(ValueReference.of(this.customIncident())).keyPrefix(ValueReference.of(this.keyPrefix())).clientName(ValueReference.of(this.clientName())).clientUrl(ValueReference.of(this.clientUrl())).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    implements EventNotificationConfig.Builder<Builder> {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_PagerDutyNotificationConfig.Builder().type(PagerDutyNotificationConfig.TYPE_NAME);
        }

        @JsonProperty(value="routing_key")
        public abstract Builder routingKey(String var1);

        @JsonProperty(value="custom_incident")
        public abstract Builder customIncident(boolean var1);

        @JsonProperty(value="key_prefix")
        public abstract Builder keyPrefix(String var1);

        @JsonProperty(value="client_name")
        public abstract Builder clientName(String var1);

        @JsonProperty(value="client_url")
        public abstract Builder clientUrl(String var1);

        public abstract PagerDutyNotificationConfig build();
    }
}

