/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.cef.pipelines.rules;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.github.jcustenborder.cef.CEFParser;
import com.github.jcustenborder.cef.CEFParserFactory;
import com.google.common.annotations.VisibleForTesting;
import jakarta.inject.Inject;
import java.util.HashMap;
import org.graylog.plugins.cef.parser.MappedMessage;
import org.graylog.plugins.cef.pipelines.rules.CEFParserResult;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CEFParserFunction
extends AbstractFunction<CEFParserResult> {
    private static final Logger LOG = LoggerFactory.getLogger(CEFParserFunction.class);
    public static final String NAME = "parse_cef";
    @VisibleForTesting
    static final String VALUE = "cef_string";
    static final String USE_FULL_NAMES = "use_full_names";
    private final ParameterDescriptor<String, String> valueParam = ParameterDescriptor.string("cef_string").description("The CEF string to parse").build();
    private final ParameterDescriptor<Boolean, Boolean> useFullNamesParam = ParameterDescriptor.bool("use_full_names").description("Use full field names for CEF extensions").build();
    private final Timer parseTime;

    @Inject
    public CEFParserFunction(MetricRegistry metricRegistry) {
        this.parseTime = metricRegistry.timer(MetricRegistry.name(this.getClass(), (String[])new String[]{"parseTime"}));
    }

    @Override
    public CEFParserResult evaluate(FunctionArgs args, EvaluationContext context) {
        MappedMessage message;
        String cef = this.valueParam.required(args, context);
        boolean useFullNames = this.useFullNamesParam.optional(args, context).orElse(false);
        CEFParser parser = CEFParserFactory.create();
        if (cef == null || cef.isEmpty()) {
            LOG.debug("NULL or empty parameter passed to CEF parser function. Not evaluating.");
            return null;
        }
        LOG.debug("Running CEF parser for [{}].", (Object)cef);
        try (Timer.Context timer = this.parseTime.time();){
            message = new MappedMessage(parser.parse(cef.trim()), useFullNames);
        }
        catch (Exception e) {
            LOG.error("Error while parsing CEF message: {}", (Object)cef, (Object)e);
            return null;
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("cef_version", message.cefVersion());
        fields.put("device_vendor", message.deviceVendor());
        fields.put("device_product", message.deviceProduct());
        fields.put("device_version", message.deviceVersion());
        fields.put("device_event_class_id", message.deviceEventClassId());
        fields.put("name", message.name());
        fields.put("severity", message.severity());
        fields.putAll(message.mappedExtensions());
        return new CEFParserResult(fields);
    }

    @Override
    public FunctionDescriptor<CEFParserResult> descriptor() {
        return FunctionDescriptor.builder().name(NAME).description("Parse any CEF formatted string into it's fields. This is the CEF string (starting with \"CEF:\") without a syslog envelope.").params(this.valueParam, this.useFullNamesParam).returnType(CEFParserResult.class).build();
    }
}

