/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.formatting.units.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.graylog.plugins.formatting.units.model.Unit;
import org.graylog.plugins.formatting.units.model.UnitId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record SupportedUnits(@JsonProperty(value="units", required=true) Map<String, List<Unit>> unitsGroupedByType) {
    private static final Logger LOG = LoggerFactory.getLogger(SupportedUnits.class);

    @JsonIgnore
    public Optional<Unit> getUnit(UnitId unitId) {
        Optional<Unit> unitView = this.unitsGroupedByType().getOrDefault(unitId.unitType(), List.of()).stream().filter(u -> u.abbrev().equals(unitId.abbrev())).findFirst();
        if (unitView.isEmpty()) {
            LOG.error("List of supported units does not contain unit " + unitId.abbrev() + " of type" + unitId.unitType() + ". Unit related functionality may function improperly");
        }
        return unitView;
    }
}

