/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.map.geoip;

import com.codahale.metrics.Timer;
import java.io.File;
import java.io.IOException;
import org.graylog.plugins.map.geoip.GeoIpResolver;
import org.graylog.plugins.map.geoip.IPinfoIPLocationDatabaseAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class IpInfoIpResolver<T>
extends GeoIpResolver<T> {
    protected static final Logger LOG = LoggerFactory.getLogger(IpInfoIpResolver.class);
    private final boolean disableIpInfoDbTypeCheck;
    protected IPinfoIPLocationDatabaseAdapter adapter;

    IpInfoIpResolver(Timer resolveTime, String configPath, boolean enabled, boolean disableIpInfoDbTypeCheck) {
        super(resolveTime, configPath, enabled);
        this.disableIpInfoDbTypeCheck = disableIpInfoDbTypeCheck;
    }

    @Override
    boolean createDataProvider(File configFile) {
        try {
            this.adapter = new IPinfoIPLocationDatabaseAdapter(configFile, this.disableIpInfoDbTypeCheck);
        }
        catch (IOException e) {
            LOG.warn("Error creating IPinfoIPLocationDatabaseAdapter for '{}' from file '{}'", (Object)this.getClass().getSimpleName(), (Object)configFile);
            this.adapter = null;
        }
        return this.adapter != null;
    }
}

