/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.ast;

import com.codahale.metrics.Meter;
import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.collect.Sets;
import java.util.SortedSet;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.plugins.pipelineprocessor.ast.$AutoValue_Pipeline;
import org.graylog.plugins.pipelineprocessor.ast.Stage;
import org.graylog.plugins.pipelineprocessor.processors.PipelineMetricRegistry;

@AutoValue
public abstract class Pipeline {
    private transient Meter executed;

    @Nullable
    public abstract String id();

    public abstract String name();

    public abstract SortedSet<Stage> stages();

    public static Builder builder() {
        return new $AutoValue_Pipeline.Builder();
    }

    public static Pipeline empty(String name) {
        return Pipeline.builder().name(name).stages(Sets.newTreeSet()).build();
    }

    public abstract Builder toBuilder();

    public Pipeline withId(String id) {
        return this.toBuilder().id(id).build();
    }

    @Memoized
    public abstract int hashCode();

    public void registerMetrics(PipelineMetricRegistry metricRegistry) {
        if (this.id() != null) {
            this.executed = metricRegistry.registerPipelineMeter(this.id(), "executed");
        }
    }

    public void markExecution() {
        if (this.executed != null) {
            this.executed.mark();
        }
    }

    public boolean containsRule(@Nonnull String ruleName) {
        return this.stages().stream().flatMap(stage -> stage.ruleReferences() == null ? Stream.empty() : stage.ruleReferences().stream()).anyMatch(ruleName::equals);
    }

    public String toString() {
        return "Pipeline '" + this.name() + "' (" + this.id() + ")";
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Pipeline build();

        public abstract Builder id(String var1);

        public abstract Builder name(String var1);

        public abstract Builder stages(SortedSet<Stage> var1);
    }
}

